/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.meta_api.ProvisioningProfileClient;
import cloud.metaapi.sdk.clients.meta_api.models.ProvisioningProfileDto;
import cloud.metaapi.sdk.clients.meta_api.models.ProvisioningProfileUpdateDto;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;

public class ProvisioningProfile {
    private ProvisioningProfileDto data;
    private ProvisioningProfileClient provisioningProfileClient;

    public ProvisioningProfile(ProvisioningProfileDto data, ProvisioningProfileClient provisioningProfileClient) {
        this.data = data;
        this.provisioningProfileClient = provisioningProfileClient;
    }

    public String getId() {
        return this.data._id;
    }

    public String getName() {
        return this.data.name;
    }

    public int getVersion() {
        return this.data.version;
    }

    public String getStatus() {
        return this.data.status;
    }

    public String getBrokerTimezone() {
        return this.data.brokerTimezone;
    }

    public String getBrokerDSTSwitchTimezone() {
        return this.data.brokerDSTSwitchTimezone;
    }

    public CompletableFuture<Void> reload() {
        return this.provisioningProfileClient.getProvisioningProfile(this.getId()).thenAccept(profile -> {
            this.data = profile;
        });
    }

    public CompletableFuture<Void> remove() {
        return this.provisioningProfileClient.deleteProvisioningProfile(this.getId());
    }

    public CompletableFuture<Void> uploadFile(String fileName, String filePath) {
        return this.provisioningProfileClient.uploadProvisioningProfileFile(this.getId(), fileName, filePath);
    }

    public CompletableFuture<Void> uploadFile(String fileName, InputStream fileContents) {
        return this.provisioningProfileClient.uploadProvisioningProfileFile(this.getId(), fileName, fileContents);
    }

    public CompletableFuture<Void> update(ProvisioningProfileUpdateDto profile) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        CompletableFuture.runAsync(() -> {
            try {
                this.provisioningProfileClient.updateProvisioningProfile(this.getId(), profile).get();
                this.reload().get();
                result.complete(null);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }
}

