/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client;

import cloud.prefab.client.PrefabCloudClient;
import cloud.prefab.client.config.ConfigLoader;
import cloud.prefab.client.config.ConfigResolver;
import cloud.prefab.domain.ConfigServiceGrpc;
import cloud.prefab.domain.Prefab;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.S3Object;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigClient {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigClient.class);
    private static final long DEFAULT_CHECKPOINT_SEC = 60L;
    private static final long BACKOFF_MILLIS = 3000L;
    private final PrefabCloudClient baseClient;
    private final ConfigResolver resolver;
    private final ConfigLoader configLoader;
    private final AmazonS3 s3Client;
    private static final String bucket = "prefab-cloud-checkpoints-prod";
    private CountDownLatch initializedLatch = new CountDownLatch(1);

    public ConfigClient(PrefabCloudClient baseClient) {
        this.baseClient = baseClient;
        this.configLoader = new ConfigLoader();
        this.resolver = new ConfigResolver(baseClient, this.configLoader);
        this.s3Client = (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(Regions.US_EAST_1)).build();
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
        ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)executor, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        executorService.execute(() -> this.startAPI());
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        scheduledExecutorService.scheduleAtFixedRate(() -> this.loadCheckpoint(), 0L, this.checkpointFreq(), TimeUnit.SECONDS);
    }

    public Optional<Prefab.ConfigValue> get(String key) {
        try {
            this.initializedLatch.await();
            return this.resolver.getConfigValue(key);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void upsert(Prefab.UpsertRequest upsertRequest) {
        this.configServiceBlockingStub().upsert(upsertRequest);
    }

    private void loadCheckpoint() {
        String key = this.baseClient.getApiKey().replace("|", "/");
        S3Object object = this.s3Client.getObject(bucket, key);
        try {
            Prefab.ConfigDeltas configDeltas = Prefab.ConfigDeltas.parseFrom((InputStream)object.getObjectContent());
            this.loadDeltas(configDeltas);
        }
        catch (Exception e) {
            LOG.warn("Issue Loading Checkpoint", (Throwable)e);
        }
    }

    private void startAPI() {
        this.startAPI(this.configLoader.getHighwaterMark());
    }

    private void startAPI(long highwaterMark) {
        Prefab.ConfigServicePointer pointer = Prefab.ConfigServicePointer.newBuilder().setStartAtId(highwaterMark).setAccountId(this.baseClient.getAccountId()).build();
        this.configServiceStub().getConfig(pointer, new StreamObserver<Prefab.ConfigDeltas>(){

            public void onNext(Prefab.ConfigDeltas configDeltas) {
                ConfigClient.this.loadDeltas(configDeltas);
            }

            public void onError(Throwable throwable) {
                LOG.warn("Error from API");
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    LOG.warn("Interruption Backing Off");
                }
                ConfigClient.this.startAPI();
            }

            public void onCompleted() {
                LOG.warn("Unexpected stream completions");
                ConfigClient.this.startAPI();
            }
        });
    }

    private void loadDeltas(Prefab.ConfigDeltas configDeltas) {
        for (Prefab.ConfigDelta configDelta : configDeltas.getDeltasList()) {
            this.configLoader.set(configDelta);
        }
        this.resolver.update();
        LOG.debug("Load Highwater " + this.configLoader.getHighwaterMark());
        this.initializedLatch.countDown();
    }

    private ConfigServiceGrpc.ConfigServiceBlockingStub configServiceBlockingStub() {
        return ConfigServiceGrpc.newBlockingStub((Channel)this.baseClient.getChannel());
    }

    private ConfigServiceGrpc.ConfigServiceStub configServiceStub() {
        return ConfigServiceGrpc.newStub((Channel)this.baseClient.getChannel());
    }

    private long checkpointFreq() {
        try {
            String checkpointFrequency = System.getenv("PREFAB_CHECKPOINT_FREQ_SEC");
            if (!checkpointFrequency.isEmpty()) {
                return Long.parseLong(checkpointFrequency);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        return 60L;
    }
}

