/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client;

import cloud.prefab.client.ConfigClient;
import cloud.prefab.client.PrefabCloudClient;
import cloud.prefab.client.util.RandomProvider;
import cloud.prefab.client.util.RandomProviderIF;
import cloud.prefab.domain.Prefab;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class FeatureFlagClient {
    private static final HashFunction hash = Hashing.murmur3_32();
    private static final long UNSIGNED_INT_MAX = 0xFFFFFFFEL;
    private final PrefabCloudClient baseClient;
    private RandomProviderIF randomProvider = new RandomProvider();

    public FeatureFlagClient(PrefabCloudClient baseClient) {
        this.baseClient = baseClient;
    }

    public boolean featureIsOn(String feature) {
        return this.featureIsOnFor(feature, Optional.empty(), Lists.newArrayList());
    }

    public boolean featureIsOnFor(String feature, Optional<String> key, List<String> attributes) {
        ConfigClient configClient = this.baseClient.configClient();
        Optional<Prefab.ConfigValue> configValue = configClient.get(feature);
        if (configValue.isPresent() && configValue.get().getTypeCase() == Prefab.ConfigValue.TypeCase.FEATURE_FLAG) {
            return this.isOnFor(configValue.get().getFeatureFlag(), feature, key, attributes);
        }
        return true;
    }

    protected boolean isOnFor(Prefab.FeatureFlag featureFlag, String feature, Optional<String> key, List<String> attributes) {
        if (key.isPresent()) {
            attributes.add(key.get());
        }
        attributes.retainAll((Collection<?>)featureFlag.getWhitelistedList());
        if (!attributes.isEmpty()) {
            return true;
        }
        if (key.isPresent()) {
            String toHash = String.format("%d%s%s", this.baseClient.getAccountId(), feature, key.get());
            return this.getUserPct(toHash) < featureFlag.getPct();
        }
        return featureFlag.getPct() > this.randomProvider.random();
    }

    double getUserPct(String toHash) {
        HashCode hashCode = hash.hashBytes(toHash.getBytes());
        return this.pct(hashCode.asInt());
    }

    private double pct(int signedInt) {
        long y = (long)signedInt & 0xFFFFFFFFL;
        return (double)y / 4.294967294E9;
    }

    public FeatureFlagClient setRandomProvider(RandomProviderIF randomProvider) {
        this.randomProvider = randomProvider;
        return this;
    }
}

