/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.config;

import cloud.prefab.domain.Prefab;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.yaml.snakeyaml.Yaml;

public class ConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigLoader.class);
    private ConcurrentMap<String, Prefab.ConfigDelta> apiConfig = new ConcurrentHashMap<String, Prefab.ConfigDelta>();
    private long highwaterMark = 0L;
    private Map<String, Prefab.ConfigDelta> classPathConfig = this.loadClasspathConfig();
    private Map<String, Prefab.ConfigDelta> overrideConfig = this.loadOverrideConfig();

    public Map<String, Prefab.ConfigDelta> calcConfig() {
        HashMap<String, Prefab.ConfigDelta> rtn = new HashMap<String, Prefab.ConfigDelta>(this.classPathConfig);
        this.apiConfig.forEach((k, v) -> rtn.put((String)k, (Prefab.ConfigDelta)v));
        this.overrideConfig.forEach((k, v) -> rtn.put((String)k, (Prefab.ConfigDelta)v));
        return rtn;
    }

    public void set(Prefab.ConfigDelta delta) {
        Prefab.ConfigDelta existing = (Prefab.ConfigDelta)this.apiConfig.get(delta.getKey());
        if (existing == null || existing.getId() <= delta.getId()) {
            if (delta.getValue().getTypeCase() == Prefab.ConfigValue.TypeCase.TYPE_NOT_SET) {
                this.apiConfig.remove(delta.getKey());
            } else {
                this.apiConfig.put(delta.getKey(), delta);
            }
            this.recomputeHighWaterMark();
        }
    }

    private void recomputeHighWaterMark() {
        Optional<Prefab.ConfigDelta> highwaterMarkDelta = this.apiConfig.values().stream().max(new Comparator<Prefab.ConfigDelta>(){

            @Override
            public int compare(Prefab.ConfigDelta o1, Prefab.ConfigDelta o2) {
                return (int)(o1.getId() - o2.getId());
            }
        });
        this.highwaterMark = highwaterMarkDelta.isPresent() ? highwaterMarkDelta.get().getId() : 0L;
    }

    private Map<String, Prefab.ConfigDelta> loadClasspathConfig() {
        HashMap<String, Prefab.ConfigDelta> rtn = new HashMap<String, Prefab.ConfigDelta>();
        try {
            Resource[] mappingLocations;
            PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();
            for (Resource mappingLocation : mappingLocations = patternResolver.getResources("classpath*:.prefab*config.yaml")) {
                this.loadFileTo(mappingLocation.getFile(), rtn);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            e.printStackTrace();
        }
        return rtn;
    }

    private Prefab.ConfigDelta toValue(Object obj) {
        Prefab.ConfigValue.Builder builder = Prefab.ConfigValue.newBuilder();
        if (obj instanceof Boolean) {
            builder.setBool((Boolean)obj);
        } else if (obj instanceof Integer) {
            builder.setInt(((Integer)obj).intValue());
        } else if (obj instanceof Double) {
            builder.setDouble((Double)obj);
        } else if (obj instanceof String) {
            builder.setString((String)obj);
        }
        return Prefab.ConfigDelta.newBuilder().setValue(builder.build()).build();
    }

    private Map<String, Prefab.ConfigDelta> loadOverrideConfig() {
        File[] files;
        HashMap<String, Prefab.ConfigDelta> rtn = new HashMap<String, Prefab.ConfigDelta>();
        File dir = new File(System.getProperty("user.home"));
        for (File file : files = dir.listFiles((dir1, name) -> name.matches("\\.prefab.*config\\.yaml"))) {
            this.loadFileTo(file, rtn);
        }
        return rtn;
    }

    private void loadFileTo(File file, Map<String, Prefab.ConfigDelta> rtn) {
        try {
            Yaml yaml = new Yaml();
            Map obj = null;
            obj = (Map)yaml.load((InputStream)new FileInputStream(file));
            obj.forEach((k, v) -> rtn.put((String)k, this.toValue(v)));
        }
        catch (FileNotFoundException e) {
            LOG.error(e.getMessage());
            e.printStackTrace();
        }
    }

    public long getHighwaterMark() {
        return this.highwaterMark;
    }
}

