/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.config;

import cloud.prefab.client.PrefabCloudClient;
import cloud.prefab.client.config.ConfigLoader;
import cloud.prefab.client.config.ResolverElement;
import cloud.prefab.domain.Prefab;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class ConfigResolver {
    private final PrefabCloudClient baseClient;
    private final ConfigLoader configLoader;
    private AtomicReference<Map<String, ResolverElement>> localMap = new AtomicReference(new HashMap());

    public ConfigResolver(PrefabCloudClient baseClient, ConfigLoader configLoader) {
        this.baseClient = baseClient;
        this.configLoader = configLoader;
        this.makeLocal();
    }

    public Optional<Prefab.ConfigValue> getConfigValue(String key) {
        ResolverElement resolverElement = this.localMap.get().get(key);
        if (resolverElement != null) {
            return Optional.of(resolverElement.getConfigDelta().getValue());
        }
        return Optional.empty();
    }

    public void update() {
        this.makeLocal();
    }

    private void makeLocal() {
        HashMap map = new HashMap();
        String baseNamespace = this.baseClient.getNamespace();
        this.configLoader.calcConfig().forEach((key, value) -> {
            String property = key;
            String propertyNamespace = "";
            String[] split = key.split(":");
            if (split.length > 1) {
                propertyNamespace = split[0];
                StringBuilder sb = new StringBuilder();
                for (int i = 1; i < split.length; ++i) {
                    sb.append(split[i]);
                }
                property = sb.toString();
            }
            if (propertyNamespace.equals("") || baseNamespace.startsWith(propertyNamespace)) {
                ResolverElement existing = (ResolverElement)map.get(property);
                if (existing == null) {
                    map.put(property, new ResolverElement((Prefab.ConfigDelta)value, propertyNamespace));
                } else if (existing.getNamespace().split("\\.").length < propertyNamespace.split("\\.").length) {
                    map.put(property, new ResolverElement((Prefab.ConfigDelta)value, propertyNamespace));
                }
            }
        });
        this.localMap.set(map);
    }
}

