/*
 * Decompiled with CFR 0.152.
 */
package com.jfplugin.xsql.core;

import com.jfplugin.xsql.core.NodeParser;
import com.jfplugin.xsql.core.SqlMapParser;
import com.jfplugin.xsql.core.SqlStatementMapping;
import com.jfplugin.xsql.core.StatementBuilder;
import com.jfplugin.xsql.exception.SqlMapPathException;
import com.jfplugin.xsql.statement.SqlStatement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SqlConfigParser {
    private SqlStatementMapping statementMapping = new SqlStatementMapping();
    private NodeParser nodeParser = new NodeParser();

    public void parser(InputStream in) {
        Document doc = this.nodeParser.parser(in);
        Node sqlconfignode = doc.getElementsByTagName("sqlconfig").item(0);
        NodeList children = sqlconfignode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if ("statements".equals(node.getNodeName().toLowerCase())) {
                NodeList statements = node.getChildNodes();
                for (int j = 0; j < statements.getLength(); ++j) {
                    Node statement = statements.item(j);
                    if (!"statement".equals(statement.getNodeName().toLowerCase())) continue;
                    String tag = this.nodeParser.attr(statement, "tag");
                    String clazz = this.nodeParser.attr(statement, "class");
                    StatementBuilder.register(tag, clazz);
                }
            }
            if (!"sqlmap".equals(node.getNodeName().toLowerCase())) continue;
            String path = node.getAttributes().getNamedItem("path").getNodeValue();
            InputStream sqlmapin = null;
            try {
                sqlmapin = path.startsWith("file:") ? new FileInputStream(new File(path.replace("file:", ""))) : this.getClass().getClassLoader().getResourceAsStream(path.replace("classpath:", ""));
                new SqlMapParser().parser(sqlmapin, this.statementMapping);
                continue;
            }
            catch (Exception e) {
                throw new SqlMapPathException("sqlmap \u7684 path:" + path + "\uff0c\u5f02\u5e38", e);
            }
            finally {
                if (sqlmapin != null) {
                    try {
                        sqlmapin.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public SqlStatement get(String sqlId) {
        return this.statementMapping.get(sqlId);
    }
}

