/*
 * Decompiled with CFR 0.152.
 */
package com.jfplugin.xsql.core;

import com.jfplugin.xsql.exception.NodeNotAllowedException;
import com.jfplugin.xsql.exception.StatementException;
import com.jfplugin.xsql.statement.CommentStatement;
import com.jfplugin.xsql.statement.ForeachStatement;
import com.jfplugin.xsql.statement.IsEmptyStatement;
import com.jfplugin.xsql.statement.IsNotEmptyStatement;
import com.jfplugin.xsql.statement.SqlStatement;
import com.jfplugin.xsql.statement.Statement;
import com.jfplugin.xsql.statement.TextStatement;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StatementBuilder {
    private static Map<String, Class<? extends Statement>> registerMap = new HashMap<String, Class<? extends Statement>>();

    public static SqlStatement builder(Node sqlnode) {
        SqlStatement sqlNodeStatement = new SqlStatement(sqlnode);
        StatementBuilder.buildChild(sqlNodeStatement, sqlnode.getChildNodes());
        return sqlNodeStatement;
    }

    private static void buildChild(Statement statement, NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Statement nodeStatement = StatementBuilder.createStatement(node);
            if (node.getChildNodes().getLength() > 0) {
                StatementBuilder.buildChild(nodeStatement, node.getChildNodes());
            }
            statement.addChild(nodeStatement);
        }
    }

    private static Statement createStatement(Node node) {
        String tag = node.getNodeName().toLowerCase();
        Class<? extends Statement> clazz = registerMap.get(tag);
        if (clazz != null) {
            try {
                return clazz.getConstructor(Node.class).newInstance(node);
            }
            catch (Exception e) {
                throw new StatementException("\u521b\u5efa" + clazz + "\u5f02\u5e38!", e);
            }
        }
        throw new NodeNotAllowedException(tag + "\u6807\u7b7e\u65e0\u6cd5\u8bc6\u522b");
    }

    public static void register(String tag, Class<? extends Statement> clazz) {
        registerMap.put(tag, clazz);
    }

    public static void register(String tag, String clazz) {
        try {
            registerMap.put(tag, Class.forName(clazz));
        }
        catch (Exception e) {
            throw new RuntimeException(clazz + "\u6ce8\u518c\u5931\u8d25!", e);
        }
    }

    static {
        registerMap.put("foreach", ForeachStatement.class);
        registerMap.put("isempty", IsEmptyStatement.class);
        registerMap.put("isnotempty", IsNotEmptyStatement.class);
        registerMap.put("#text", TextStatement.class);
        registerMap.put("#comment", CommentStatement.class);
    }
}

