/*
 * Decompiled with CFR 0.152.
 */
package com.jfplugin.xsql.statement;

import com.jfplugin.xsql.core.Context;
import com.jfplugin.xsql.core.VarParser;
import com.jfplugin.xsql.statement.Statement;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

public class TextStatement
extends Statement {
    private static final String VAR_REG = "#\\{([^\\{\\}])+\\}";
    private static final String CONST_REG = "\\$\\{([^\\\\{\\\\}])+\\}";
    private static final Pattern VAR_PATTERN = Pattern.compile("#\\{([^\\{\\}])+\\}");
    private static final Pattern CONST_PATTERN = Pattern.compile("\\$\\{([^\\\\{\\\\}])+\\}");

    public TextStatement(Node node) {
        super(node);
    }

    @Override
    public void execute(Context ctx, Object localVar) {
        Var var;
        int i;
        ArrayList<Var> vars = new ArrayList<Var>();
        ArrayList<Object> reverseArgs = new ArrayList<Object>();
        String text = this.node.getTextContent();
        Matcher matcher = VAR_PATTERN.matcher(text);
        while (matcher.find()) {
            Var var2 = new Var();
            var2.start = matcher.start();
            var2.end = matcher.end();
            var2.text = text.substring(var2.start + 2, var2.end - 1);
            vars.add(var2);
        }
        for (i = vars.size() - 1; i >= 0; --i) {
            var = (Var)vars.get(i);
            text = text.substring(0, var.start) + "?" + text.substring(var.end, text.length());
            reverseArgs.add(VarParser.parser(var.text, ctx.globalVar, localVar));
        }
        for (i = reverseArgs.size() - 1; i >= 0; --i) {
            ctx.args.add(reverseArgs.get(i));
        }
        matcher = CONST_PATTERN.matcher(text);
        vars.clear();
        while (matcher.find()) {
            Var var3 = new Var();
            var3.start = matcher.start();
            var3.end = matcher.end();
            var3.text = text.substring(var3.start + 2, var3.end - 1);
            vars.add(var3);
        }
        for (int i2 = vars.size() - 1; i2 >= 0; --i2) {
            var = (Var)vars.get(i2);
            text = text.substring(0, var.start) + VarParser.parser(var.text, ctx.globalVar, localVar) + text.substring(var.end, text.length());
        }
        ctx.sw.append(text);
    }

    static class Var {
        int start;
        int end;
        String text;

        Var() {
        }
    }
}

