/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.fcmjava.client;

import de.bytefish.fcmjava.client.interceptors.request.AuthenticationRequestInterceptor;
import de.bytefish.fcmjava.client.interceptors.request.JsonRequestInterceptor;
import de.bytefish.fcmjava.client.interceptors.request.LoggingRequestInterceptor;
import de.bytefish.fcmjava.client.interceptors.response.LoggingResponseInterceptor;
import de.bytefish.fcmjava.client.interceptors.response.StatusResponseInterceptor;
import de.bytefish.fcmjava.client.utils.HttpUtils;
import de.bytefish.fcmjava.http.client.IFcmClient;
import de.bytefish.fcmjava.http.options.IFcmClientSettings;
import de.bytefish.fcmjava.requests.data.DataMulticastMessage;
import de.bytefish.fcmjava.requests.data.DataUnicastMessage;
import de.bytefish.fcmjava.requests.groups.AddDeviceGroupMessage;
import de.bytefish.fcmjava.requests.groups.CreateDeviceGroupMessage;
import de.bytefish.fcmjava.requests.groups.RemoveDeviceGroupMessage;
import de.bytefish.fcmjava.requests.notification.NotificationMulticastMessage;
import de.bytefish.fcmjava.requests.notification.NotificationUnicastMessage;
import de.bytefish.fcmjava.requests.topic.TopicMulticastMessage;
import de.bytefish.fcmjava.requests.topic.TopicUnicastMessage;
import de.bytefish.fcmjava.responses.CreateDeviceGroupMessageResponse;
import de.bytefish.fcmjava.responses.MulticastMessageResponse;
import de.bytefish.fcmjava.responses.TopicMessageResponse;
import de.bytefish.fcmjava.responses.UnicastMessageResponse;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.client.HttpClientBuilder;

public class FcmClient
implements IFcmClient {
    private final IFcmClientSettings settings;
    private final HttpClientBuilder httpClientBuilder;

    public FcmClient(IFcmClientSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("settings");
        }
        this.settings = settings;
        this.httpClientBuilder = HttpClientBuilder.create().addInterceptorFirst((HttpRequestInterceptor)new AuthenticationRequestInterceptor(settings.getApiKey())).addInterceptorLast((HttpRequestInterceptor)new JsonRequestInterceptor()).addInterceptorLast((HttpRequestInterceptor)new LoggingRequestInterceptor()).addInterceptorFirst((HttpResponseInterceptor)new LoggingResponseInterceptor()).addInterceptorLast((HttpResponseInterceptor)new StatusResponseInterceptor());
    }

    public MulticastMessageResponse send(DataMulticastMessage message) {
        return this.post(message, MulticastMessageResponse.class);
    }

    public MulticastMessageResponse send(NotificationMulticastMessage notification) {
        return this.post(notification, MulticastMessageResponse.class);
    }

    public UnicastMessageResponse send(DataUnicastMessage message) {
        return this.post(message, UnicastMessageResponse.class);
    }

    public UnicastMessageResponse send(NotificationUnicastMessage notification) {
        return this.post(notification, UnicastMessageResponse.class);
    }

    public CreateDeviceGroupMessageResponse send(CreateDeviceGroupMessage message) {
        return this.post(message, CreateDeviceGroupMessageResponse.class);
    }

    public TopicMessageResponse send(TopicUnicastMessage message) {
        return this.post(message, TopicMessageResponse.class);
    }

    public TopicMessageResponse send(TopicMulticastMessage message) {
        return this.post(message, TopicMessageResponse.class);
    }

    public void send(RemoveDeviceGroupMessage message) {
        this.post(message);
    }

    public void send(AddDeviceGroupMessage message) {
        this.post(message);
    }

    protected <TRequestMessage, TResponseMessage> TResponseMessage post(TRequestMessage requestMessage, Class<TResponseMessage> responseType) {
        try {
            return HttpUtils.post(this.httpClientBuilder, this.settings, requestMessage, responseType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected <TRequestMessage> void post(TRequestMessage requestMessage) {
        try {
            HttpUtils.post(this.httpClientBuilder, this.settings, requestMessage);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

