/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.fcmjava.client.http.apache;

import de.bytefish.fcmjava.client.http.IHttpClient;
import de.bytefish.fcmjava.client.http.apache.utils.RetryHeaderUtils;
import de.bytefish.fcmjava.client.utils.JsonUtils;
import de.bytefish.fcmjava.client.utils.OutParameter;
import de.bytefish.fcmjava.exceptions.FcmAuthenticationException;
import de.bytefish.fcmjava.exceptions.FcmBadRequestException;
import de.bytefish.fcmjava.exceptions.FcmCommunicationException;
import de.bytefish.fcmjava.exceptions.FcmGeneralException;
import de.bytefish.fcmjava.exceptions.FcmRetryAfterException;
import de.bytefish.fcmjava.http.options.IFcmClientSettings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class DefaultHttpClient
implements IHttpClient {
    private final IFcmClientSettings settings;
    private final HttpClientBuilder httpClientBuilder;

    public DefaultHttpClient(IFcmClientSettings settings) {
        this(settings, HttpClientBuilder.create());
    }

    public DefaultHttpClient(IFcmClientSettings settings, HttpClientBuilder httpClientBuilder) {
        if (settings == null) {
            throw new IllegalArgumentException("settings");
        }
        if (httpClientBuilder == null) {
            throw new IllegalArgumentException("httpClientBuilder");
        }
        this.settings = settings;
        this.httpClientBuilder = httpClientBuilder;
    }

    private <TRequestMessage> void internalPost(TRequestMessage requestMessage) throws IOException {
        try (CloseableHttpClient client = this.httpClientBuilder.build();
             CloseableHttpResponse response = client.execute(this.buildPostRequest(requestMessage));){
            this.evaluateResponse((HttpResponse)response);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                EntityUtils.consume((HttpEntity)entity);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private <TRequestMessage, TResponseMessage> TResponseMessage internalPost(TRequestMessage requestMessage, Class<TResponseMessage> responseType) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 31[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <TRequestMessage> HttpUriRequest buildPostRequest(TRequestMessage requestMessage) {
        String content = JsonUtils.getAsJsonString(requestMessage);
        return RequestBuilder.post((String)this.settings.getFcmUrl()).addHeader("Authorization", String.format("key=%s", this.settings.getApiKey())).setHeader("Content-Type", "application/json").setEntity((HttpEntity)new StringEntity(content, StandardCharsets.UTF_8)).build();
    }

    private void evaluateResponse(HttpResponse httpResponse) {
        OutParameter<Duration> result;
        if (httpResponse == null) {
            return;
        }
        if (httpResponse.getStatusLine() == null) {
            return;
        }
        int httpStatusCode = httpResponse.getStatusLine().getStatusCode();
        if (httpStatusCode == 200) {
            return;
        }
        String reasonPhrase = httpResponse.getStatusLine().getReasonPhrase();
        if (httpStatusCode == 400) {
            throw new FcmBadRequestException(reasonPhrase);
        }
        if (httpStatusCode == 401) {
            throw new FcmAuthenticationException(reasonPhrase);
        }
        if (httpStatusCode >= 500 && httpStatusCode < 600 && RetryHeaderUtils.tryDetermineRetryDelay(httpResponse, result = new OutParameter<Duration>())) {
            throw new FcmRetryAfterException(result.get(), reasonPhrase);
        }
        throw new FcmGeneralException(reasonPhrase);
    }

    @Override
    public <TRequestMessage> void post(TRequestMessage requestMessage) {
        try {
            this.internalPost(requestMessage);
        }
        catch (IOException e) {
            throw new FcmCommunicationException("Error making POST Request", (Throwable)e);
        }
    }

    @Override
    public <TRequestMessage, TResponseMessage> TResponseMessage post(TRequestMessage requestMessage, Class<TResponseMessage> responseType) {
        try {
            return this.internalPost(requestMessage, responseType);
        }
        catch (IOException e) {
            throw new FcmCommunicationException("Error making POST Request", (Throwable)e);
        }
    }
}

