/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.cmdline;

import de.carne.check.Nullable;
import de.carne.util.Strings;
import de.carne.util.cmdline.CmdLineAction;
import de.carne.util.cmdline.CmdLineActionBiConsumer;
import de.carne.util.cmdline.CmdLineActionConsumer;
import de.carne.util.cmdline.CmdLineActionException;
import de.carne.util.cmdline.CmdLineException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class CmdLine {
    private final Iterable<String> args;
    private final List<CmdLineActionConsumer> switchActions = new ArrayList<CmdLineActionConsumer>();
    private final List<CmdLineActionBiConsumer> namedOptionActions = new ArrayList<CmdLineActionBiConsumer>();
    @Nullable
    private CmdLineActionConsumer unnamedOptionAction = null;
    @Nullable
    private CmdLineActionConsumer unknownArgumentAction = null;

    public CmdLine(String[] args) {
        this.args = Arrays.asList(args);
    }

    public CmdLine(Iterable<String> args) {
        this.args = args;
    }

    public void eval() throws CmdLineException {
        CmdLineActionBiConsumer pendingNamedOptionAction = null;
        String pendingArg = null;
        try {
            for (String arg : this.args) {
                if (Strings.isEmpty(arg)) continue;
                if (pendingNamedOptionAction != null) {
                    pendingNamedOptionAction.accept(pendingArg, arg);
                    pendingNamedOptionAction = null;
                    pendingArg = null;
                    continue;
                }
                pendingNamedOptionAction = CmdLine.matchAction(this.namedOptionActions, arg);
                if (pendingNamedOptionAction != null) {
                    pendingArg = arg;
                    continue;
                }
                CmdLineActionConsumer matchingSwitchAction = CmdLine.matchAction(this.switchActions, arg);
                if (matchingSwitchAction != null) {
                    matchingSwitchAction.accept(arg);
                    continue;
                }
                CmdLineActionConsumer checkedUnnamedOptionAction = this.unnamedOptionAction;
                if (checkedUnnamedOptionAction != null) {
                    checkedUnnamedOptionAction.accept(arg);
                    continue;
                }
                CmdLineActionConsumer checkedUnknownArgumentAction = this.unknownArgumentAction;
                if (checkedUnknownArgumentAction == null) continue;
                checkedUnknownArgumentAction.accept(arg);
            }
            if (pendingNamedOptionAction != null) {
                pendingNamedOptionAction.accept(pendingArg, "");
                pendingNamedOptionAction = null;
                pendingArg = null;
            }
        }
        catch (CmdLineActionException e) {
            throw new CmdLineException(e);
        }
    }

    @Nullable
    private static <T extends CmdLineAction> T matchAction(List<T> actions, String arg) {
        CmdLineAction matchingAction = null;
        for (CmdLineAction action : actions) {
            if (!action.match(arg)) continue;
            matchingAction = action;
            break;
        }
        return (T)matchingAction;
    }

    public CmdLineAction switchAction(Consumer<String> consumer) {
        CmdLineActionConsumer switchAction = new CmdLineActionConsumer(consumer);
        this.switchActions.add(switchAction);
        return switchAction;
    }

    public CmdLineAction namedOptionAction(BiConsumer<String, String> consumer) {
        CmdLineActionBiConsumer namedOptionAction = new CmdLineActionBiConsumer(consumer);
        this.namedOptionActions.add(namedOptionAction);
        return namedOptionAction;
    }

    public void unnamedOptionAction(Consumer<String> consumer) {
        this.unnamedOptionAction = new CmdLineActionConsumer(consumer);
    }

    public void unknownArgument(Consumer<String> consumer) {
        this.unknownArgumentAction = new CmdLineActionConsumer(consumer);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (String arg : this.args) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(arg);
        }
        return Strings.safe(buffer.toString());
    }
}

