/*
 * Decompiled with CFR 0.152.
 */
package de.carne;

import de.carne.ApplicationURLStreamHandlerFactory;
import de.carne.Main;
import de.carne.check.Check;
import de.carne.check.Nullable;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class ApplicationLoader
extends URLClassLoader {
    private static final boolean DEBUG;
    private static final String RESOURCE_PROTOCOL = "resource";
    private static String[] SYSTEM_CLASS_PREFIXES;
    private static final ClassLoader SYSTEM_CLASS_LOADER;
    private static Path CODE_PATH;
    private static final URL[] RESOURCE_URLS;

    static URLConnection openResourceConnection(URL u) {
        return new URLConnection(u){

            @Override
            public void connect() throws IOException {
            }

            @Override
            public InputStream getInputStream() throws IOException {
                URL resourceURL = this.getURL();
                InputStream resourceStream = ApplicationLoader.class.getResourceAsStream(resourceURL.getFile());
                if (resourceStream == null) {
                    throw new FileNotFoundException("Unknown resource: " + resourceURL);
                }
                return resourceStream;
            }
        };
    }

    public static URL getDirectURL(URL u) {
        return RESOURCE_PROTOCOL.equals(u.getProtocol()) ? ApplicationLoader.class.getResource(u.getFile()) : u;
    }

    @Override
    public Class<?> loadClass(@Nullable String name) throws ClassNotFoundException {
        Class<?> cls = null;
        if (name != null) {
            for (String systemClassPrefix : SYSTEM_CLASS_PREFIXES) {
                if (!name.startsWith(systemClassPrefix)) continue;
                cls = SYSTEM_CLASS_LOADER.loadClass(name);
                break;
            }
        }
        if (cls == null) {
            cls = super.loadClass(name);
        }
        return cls;
    }

    @Nullable
    public static JarFile getApplicationJarFile() throws IOException {
        JarFile applicationJarFile = null;
        if (Files.isRegularFile(CODE_PATH, new LinkOption[0])) {
            applicationJarFile = new JarFile(CODE_PATH.toFile());
        }
        return applicationJarFile;
    }

    private ApplicationLoader() {
        super(RESOURCE_URLS, RESOURCE_URLS.length > 0 ? null : ApplicationLoader.getSystemClassLoader());
        ClassLoader.registerAsParallelCapable();
    }

    public static void main(String[] args) {
        int status;
        try (ApplicationLoader classLoader = new ApplicationLoader();){
            Thread.currentThread().setContextClassLoader(classLoader);
            if (DEBUG) {
                ApplicationLoader.logOut("Invoking application...");
            }
            status = ApplicationLoader.loadMain(classLoader).newInstance().run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            status = -1;
        }
        if (DEBUG) {
            ApplicationLoader.logOut("Exit status " + status);
        }
        if (status != 0) {
            System.exit(status);
        }
    }

    private static Class<? extends Main> loadMain(ClassLoader classLoader) throws IOException, ClassNotFoundException {
        Class<Main> mainClass;
        try (InputStream mainStream = ApplicationLoader.getConfigAsInputStream();
             BufferedReader mainReader = new BufferedReader(new InputStreamReader(mainStream, StandardCharsets.UTF_8));){
            String propertyLine;
            String mainClassName = mainReader.readLine();
            if (mainClassName == null) {
                throw new IllegalArgumentException("ApplicationLoader config is empty");
            }
            if (DEBUG) {
                ApplicationLoader.logOut("Main-Class " + mainClassName);
            }
            while ((propertyLine = mainReader.readLine()) != null) {
                String propertyValue;
                String propertyKey;
                int splitIndex = propertyLine.indexOf(61);
                if (splitIndex < 0) {
                    propertyKey = propertyLine.trim();
                    propertyValue = "true";
                } else if (splitIndex > 0) {
                    propertyKey = propertyLine.substring(0, splitIndex).trim();
                    propertyValue = propertyLine.substring(splitIndex + 1).trim();
                } else {
                    propertyKey = "";
                    propertyValue = "";
                }
                if (propertyKey.length() > 0 && propertyValue.length() > 0) {
                    if (DEBUG) {
                        ApplicationLoader.logOut("Setting system property \"" + propertyKey + "\" = \"" + propertyValue + "\"");
                    }
                    System.setProperty(propertyKey, propertyValue);
                    continue;
                }
                ApplicationLoader.logErr("Ignoring invalid system property definition '" + propertyLine + "'");
            }
            mainClass = classLoader.loadClass(mainClassName).asSubclass(Main.class);
        }
        return mainClass;
    }

    private static InputStream getConfigAsInputStream() {
        String resourceName = "/" + ApplicationLoader.class.getSimpleName();
        InputStream mainStream = ApplicationLoader.class.getResourceAsStream(resourceName);
        if (mainStream == null) {
            throw new IllegalStateException("Unable to access ApplicationLoader config " + resourceName);
        }
        return mainStream;
    }

    private static void logOut(String msg) {
        System.out.println("ApplicationLoader: " + msg);
    }

    private static void logErr(String msg) {
        System.err.println("ApplicationLoader: " + msg);
    }

    static {
        Path codePath;
        DEBUG = Boolean.getBoolean(ApplicationLoader.class.getName() + ".DEBUG");
        ApplicationURLStreamHandlerFactory.registerURLStreamHandlerFactory(RESOURCE_PROTOCOL, protocol -> {
            URLStreamHandler handler = null;
            if (RESOURCE_PROTOCOL.equals(protocol)) {
                handler = new URLStreamHandler(){

                    @Override
                    @Nullable
                    protected URLConnection openConnection(@Nullable URL u) throws IOException {
                        return u != null ? ApplicationLoader.openResourceConnection(u) : null;
                    }
                };
            }
            return handler;
        });
        SYSTEM_CLASS_PREFIXES = new String[]{ApplicationLoader.class.getName(), Main.class.getName(), "de.carne.util.logging"};
        ClassLoader systemClassLoader = ApplicationLoader.getSystemClassLoader();
        if (systemClassLoader == null) {
            systemClassLoader = ApplicationLoader.class.getClassLoader();
        }
        SYSTEM_CLASS_LOADER = systemClassLoader;
        try {
            CodeSource codeSource = Check.nonNull(ApplicationLoader.class.getProtectionDomain().getCodeSource(), "Unable to determine code source");
            URL codeURL = codeSource.getLocation();
            if (DEBUG) {
                ApplicationLoader.logOut("Code source URL: " + codeURL);
            }
            URI codeURI = codeURL.toURI();
            if (DEBUG) {
                ApplicationLoader.logOut("Code source URI: " + codeURI);
            }
            codePath = Paths.get(codeURI);
            if (DEBUG) {
                ApplicationLoader.logOut("Code source path: " + codePath);
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        CODE_PATH = codePath;
        ArrayList<URL> libURLs = new ArrayList<URL>();
        try (JarFile codeJar = ApplicationLoader.getApplicationJarFile();){
            if (codeJar != null) {
                libURLs.add(new URL("resource:/"));
                if (DEBUG) {
                    ApplicationLoader.logOut("Adding internal JARs to classpath...");
                }
                Iterator jarEntries = codeJar.stream().filter(entry -> entry.getName().endsWith(".jar")).iterator();
                while (jarEntries.hasNext()) {
                    String jarEntryName = ((JarEntry)jarEntries.next()).getName();
                    if (DEBUG) {
                        ApplicationLoader.logOut("Adding internal JAR: " + jarEntryName);
                    }
                    libURLs.add(new URL("jar:resource:/" + jarEntryName + "!/"));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        RESOURCE_URLS = libURLs.toArray(new URL[libURLs.size()]);
    }
}

