/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.prefs;

import de.carne.check.Nullable;
import de.carne.nio.FileAttributes;
import de.carne.util.logging.Log;
import de.carne.util.prefs.PropertiesPreferences;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

abstract class PropertiesCache {
    private final Log LOG = new Log();
    private final Properties cache = new Properties();
    @Nullable
    private FileTime propertiesLastModifiedTime = null;

    PropertiesCache() {
    }

    public static PropertiesCache fromPath(Path propertiesPath) {
        return new PathPropertiesCache(propertiesPath);
    }

    public static PropertiesCache fromUrl(URL propertiesUrl) {
        return new URLPropertiesCache(propertiesUrl);
    }

    public synchronized Map<String, String> getValues(PropertiesPreferences preferences) {
        this.initCache();
        HashMap<String, String> values = new HashMap<String, String>();
        String absolutePreferencesPath = this.getAbsolutePreferencesPath(preferences);
        for (Map.Entry<Object, Object> cacheEntry : this.cache.entrySet()) {
            Object value;
            String cacheKey = cacheEntry.getKey().toString();
            String key = this.determinePreferencesKey(absolutePreferencesPath, cacheKey);
            if (key == null || (value = cacheEntry.getValue()) == null) continue;
            values.put(key, value.toString());
        }
        return values;
    }

    public synchronized Map<String, PropertiesPreferences> getChildren(PropertiesPreferences parent) {
        this.initCache();
        HashMap<String, PropertiesPreferences> children = new HashMap<String, PropertiesPreferences>();
        String absolutePreferencesPath = this.getAbsolutePreferencesPath(parent);
        for (Map.Entry<Object, Object> cacheEntry : this.cache.entrySet()) {
            String cacheKey = cacheEntry.getKey().toString();
            String childName = this.determinePreferencesChildName(absolutePreferencesPath, cacheKey);
            if (childName == null || children.containsKey(childName)) continue;
            children.put(childName, new PropertiesPreferences(parent, childName));
        }
        return children;
    }

    public abstract void sync(PropertiesPreferences var1, @Nullable Map<String, String> var2, @Nullable Set<String> var3);

    protected synchronized void syncPath(Path propertiesPath, PropertiesPreferences preferences, @Nullable Map<String, String> modifiedValues, @Nullable Set<String> modifiedChildrenNames) {
        try {
            this.initCache();
            String absolutePreferencesPath = this.getAbsolutePreferencesPath(preferences);
            Iterator<Object> cacheKeys = this.cache.keySet().iterator();
            while (cacheKeys.hasNext()) {
                String string;
                String string2;
                String cacheKey = cacheKeys.next().toString();
                if (modifiedValues != null && (string2 = this.determinePreferencesKey(absolutePreferencesPath, cacheKey)) != null) {
                    cacheKeys.remove();
                }
                if (modifiedChildrenNames == null || (string = this.determinePreferencesChildName(absolutePreferencesPath, cacheKey)) == null || modifiedChildrenNames.contains(string)) continue;
                cacheKeys.remove();
            }
            if (modifiedValues != null) {
                for (Map.Entry entry : modifiedValues.entrySet()) {
                    String absoluteKey = absolutePreferencesPath + (String)entry.getKey();
                    this.cache.put(absoluteKey, entry.getValue());
                }
            }
            this.LOG.info("Writing preferences file ''{0}''...", propertiesPath);
            Throwable throwable = null;
            try (OutputStream propertiesStream = Files.newOutputStream(propertiesPath, new OpenOption[0]);){
                this.cache.store(propertiesStream, null);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            this.propertiesLastModifiedTime = Files.getLastModifiedTime(propertiesPath, new LinkOption[0]);
        }
        catch (IOException e) {
            this.LOG.warning(e, "An error occurred while syncing preferences file ''{0}''", propertiesPath);
        }
    }

    protected abstract void initCache();

    protected void initCacheFromPath(Path propertiesPath) {
        block15: {
            try {
                FileTime lastModifiedTime;
                if (!Files.exists(propertiesPath, new LinkOption[0])) {
                    this.LOG.info("Creating preferences file ''{0}''...", propertiesPath);
                    Path propertiesDirectoryPath = propertiesPath.getParent();
                    Files.createDirectories(propertiesDirectoryPath, FileAttributes.defaultUserDirectoryAttributes(propertiesDirectoryPath));
                    Files.createFile(propertiesPath, FileAttributes.defaultUserFileAttributes(propertiesPath));
                    this.propertiesLastModifiedTime = null;
                }
                if (Objects.equals(lastModifiedTime = Files.getLastModifiedTime(propertiesPath, new LinkOption[0]), this.propertiesLastModifiedTime)) break block15;
                this.LOG.debug("Re-loading preferences from file ''{0}''...", propertiesPath);
                try (InputStream propertiesStream = Files.newInputStream(propertiesPath, new OpenOption[0]);){
                    this.cache.clear();
                    this.cache.load(propertiesStream);
                    this.propertiesLastModifiedTime = lastModifiedTime;
                }
            }
            catch (IOException e) {
                this.LOG.warning(e, "An error occurred while initializing/reading preferences file ''{0}''", propertiesPath);
            }
        }
    }

    protected void initCacheFromUrl(URL propertiesUrl) {
        if (this.propertiesLastModifiedTime == null) {
            this.LOG.debug("Loading preferences from URL ''{0}''...", propertiesUrl);
            try (InputStream propertiesStream = propertiesUrl.openStream();){
                this.cache.clear();
                this.cache.load(propertiesStream);
                this.propertiesLastModifiedTime = FileTime.fromMillis(System.currentTimeMillis());
            }
            catch (IOException e) {
                this.LOG.warning(e, "An error occurred while reading preferences URL ''{0}''", propertiesUrl);
            }
        }
    }

    private String getAbsolutePreferencesPath(PropertiesPreferences preferences) {
        String absolutePreferencesPath = preferences.absolutePath();
        if (preferences.parent() != null) {
            absolutePreferencesPath = absolutePreferencesPath + "/";
        }
        return absolutePreferencesPath;
    }

    @Nullable
    private String determinePreferencesKey(String absolutePreferencesPath, String cacheKey) {
        String key = null;
        if (cacheKey.startsWith(absolutePreferencesPath) && cacheKey.indexOf(47, absolutePreferencesPath.length()) < 0) {
            key = cacheKey.substring(absolutePreferencesPath.length());
        }
        return key;
    }

    @Nullable
    private String determinePreferencesChildName(String absolutePreferencesPath, String cacheKey) {
        int childKeyIndex;
        String key = null;
        if (cacheKey.startsWith(absolutePreferencesPath) && (childKeyIndex = cacheKey.indexOf(47, absolutePreferencesPath.length())) > 0) {
            key = cacheKey.substring(absolutePreferencesPath.length(), childKeyIndex);
        }
        return key;
    }

    private static class URLPropertiesCache
    extends PropertiesCache {
        private final URL propertiesUrl;

        URLPropertiesCache(URL propertiesUrl) {
            this.propertiesUrl = propertiesUrl;
        }

        @Override
        public void sync(PropertiesPreferences preferences, @Nullable Map<String, String> modifiedValues, @Nullable Set<String> modifiedChildrenNames) {
        }

        @Override
        protected void initCache() {
            this.initCacheFromUrl(this.propertiesUrl);
        }
    }

    private static class PathPropertiesCache
    extends PropertiesCache {
        private final Path propertiesPath;

        PathPropertiesCache(Path propertiesPath) {
            this.propertiesPath = propertiesPath;
        }

        @Override
        public void sync(PropertiesPreferences preferences, @Nullable Map<String, String> modifiedValues, @Nullable Set<String> modifiedChildrenNames) {
            this.syncPath(this.propertiesPath, preferences, modifiedValues, modifiedChildrenNames);
        }

        @Override
        protected void initCache() {
            this.initCacheFromPath(this.propertiesPath);
        }
    }
}

