/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.prefs;

import de.carne.check.Check;
import de.carne.check.Nullable;
import de.carne.util.prefs.PropertiesCache;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;

class PropertiesPreferences
extends AbstractPreferences {
    private final PropertiesCache propertiesCache;
    @Nullable
    private Map<String, String> cachedValues = null;
    @Nullable
    private Map<String, PropertiesPreferences> cachedChildren = null;

    PropertiesPreferences(PropertiesPreferences parent, String name) {
        super(parent, name);
        this.propertiesCache = parent.propertiesCache;
    }

    PropertiesPreferences(Path propertiesPath) {
        super(null, "");
        this.propertiesCache = PropertiesCache.fromPath(propertiesPath);
    }

    PropertiesPreferences(URL propertiesUrl) {
        super(null, "");
        this.propertiesCache = PropertiesCache.fromUrl(propertiesUrl);
    }

    @Override
    protected void putSpi(@Nullable String key, @Nullable String value) {
        this.getCachedValues().put(key, value);
    }

    @Override
    protected String getSpi(@Nullable String key) {
        return this.getCachedValues().get(key);
    }

    @Override
    protected void removeSpi(@Nullable String key) {
        this.getCachedValues().remove(key);
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        this.getCachedValues().clear();
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        Set<String> keys = this.getCachedValues().keySet();
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        Collection<PropertiesPreferences> childrenPreferences = this.getCachedChildren().values();
        HashSet<String> childrenNames = new HashSet<String>(childrenPreferences.size());
        for (PropertiesPreferences childPreferences : childrenPreferences) {
            if (childPreferences.isRemoved()) continue;
            childrenNames.add(childPreferences.name());
        }
        return childrenNames.toArray(new String[childrenNames.size()]);
    }

    @Override
    protected AbstractPreferences childSpi(@Nullable String _name) {
        String name = Check.nonNull(_name);
        Map<String, PropertiesPreferences> children = this.getCachedChildren();
        PropertiesPreferences child = children.get(name);
        if (child == null) {
            child = new PropertiesPreferences(this, name);
            children.put(name, child);
        }
        return child;
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
        this.flushSpi();
        this.cachedValues = null;
        this.cachedChildren = null;
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
        if (this.cachedValues != null || this.cachedChildren != null) {
            Set<String> childrenNames = this.cachedChildren != null ? this.getChildrenNames() : null;
            this.propertiesCache.sync(this, this.cachedValues, childrenNames);
        }
    }

    private Map<String, String> getCachedValues() {
        Map<String, String> values = this.cachedValues;
        if (values == null) {
            values = this.cachedValues = this.propertiesCache.getValues(this);
        }
        return values;
    }

    private Map<String, PropertiesPreferences> getCachedChildren() {
        Map<String, PropertiesPreferences> children = this.cachedChildren;
        if (children == null) {
            children = this.cachedChildren = this.propertiesCache.getChildren(this);
        }
        return children;
    }

    private Set<String> getChildrenNames() {
        Collection<PropertiesPreferences> childrenPreferences = this.getCachedChildren().values();
        HashSet<String> childrenNames = new HashSet<String>(childrenPreferences.size());
        for (PropertiesPreferences childPreferences : childrenPreferences) {
            if (childPreferences.isRemoved()) continue;
            childrenNames.add(childPreferences.name());
        }
        return childrenNames;
    }
}

