/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.DifferDelegator;
import de.danielbechler.diff.Instances;
import de.danielbechler.diff.NodeInspector;
import de.danielbechler.diff.PropertyNodeFactory;
import de.danielbechler.diff.TestOnly;
import de.danielbechler.diff.accessor.Accessor;
import de.danielbechler.diff.node.Node;
import de.danielbechler.util.Assert;

class BeanPropertyComparisonDelegator {
    private final DifferDelegator delegator;
    private final NodeInspector nodeInspector;
    private PropertyNodeFactory propertyNodeFactory = new PropertyNodeFactory();

    public BeanPropertyComparisonDelegator(DifferDelegator delegator, NodeInspector nodeInspector) {
        Assert.notNull(delegator, "delegator");
        Assert.notNull(nodeInspector, "nodeInspector");
        this.delegator = delegator;
        this.nodeInspector = nodeInspector;
    }

    public Node compare(Node beanNode, Instances beanInstances, Accessor propertyAccessor) {
        Assert.notNull(beanNode, "beanNode");
        Assert.notNull(beanInstances, "beanInstances");
        Assert.notNull(propertyAccessor, "propertyAccessor");
        Node propertyNode = this.propertyNodeFactory.createPropertyNode(beanNode, propertyAccessor);
        if (this.nodeInspector.isIgnored(propertyNode)) {
            propertyNode.setState(Node.State.IGNORED);
            return propertyNode;
        }
        return this.delegator.delegate(beanNode, beanInstances.access(propertyAccessor));
    }

    @TestOnly
    public void setPropertyNodeFactory(PropertyNodeFactory propertyNodeFactory) {
        this.propertyNodeFactory = propertyNodeFactory;
    }
}

