/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.example;

import de.danielbechler.diff.ObjectDifferFactory;
import de.danielbechler.diff.node.Node;

public class RuntimeTypeResolutionExample {
    private RuntimeTypeResolutionExample() {
    }

    public static void main(String[] args) {
        Point base = new Point(new Coordinate3D(1L, 2L, 3L));
        Point working = new Point(new Coordinate3D(1L, 2L, 30L));
        Node node = ObjectDifferFactory.getInstance().compare(working, base);
        assert (node.getChild("coordinate").getChild("z").isChanged()) : "The changed 'z' coordinate should have been detected because the property type should be resolved to Coordinate3D at runtime.";
    }

    public static class Coordinate {
        private final long x;
        private final long y;

        public Coordinate(long x, long y) {
            this.x = x;
            this.y = y;
        }

        public long getX() {
            return this.x;
        }

        public long getY() {
            return this.y;
        }
    }

    public static class Coordinate3D
    extends Coordinate {
        private final long z;

        public Coordinate3D(long x, long y, long z) {
            super(x, y);
            this.z = z;
        }

        public long getZ() {
            return this.z;
        }
    }

    public static class Point {
        private final Coordinate coordinate;

        public Point(Coordinate coordinate) {
            this.coordinate = coordinate;
        }

        public Coordinate getCoordinate() {
            return this.coordinate;
        }
    }
}

