/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.example;

import de.danielbechler.diff.ObjectDifferFactory;
import de.danielbechler.diff.node.Node;
import de.danielbechler.diff.visitor.NodeHierarchyVisitor;
import de.danielbechler.diff.visitor.PrintingVisitor;

class SimpleNodeExample {
    private SimpleNodeExample() {
    }

    public static void main(String[] args) {
        Person bruceWayne = new Person("Bruce", "Wayne");
        Person batman = new Person("Batman", null);
        Node rootNode = ObjectDifferFactory.getInstance().compare(batman, bruceWayne);
        rootNode.visit(new NodeHierarchyVisitor(10));
        rootNode.visit(new PrintingVisitor(batman, bruceWayne){

            protected boolean filter(Node node) {
                return true;
            }
        });
    }

    private static class Person {
        private String firstName;
        private String lastName;

        private Person(String firstName, String lastName) {
            this.firstName = firstName;
            this.lastName = lastName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.firstName != null) {
                sb.append(this.firstName).append(' ');
            }
            if (this.lastName != null) {
                sb.append(this.lastName);
            }
            return sb.toString();
        }
    }
}

