/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.visitor;

import de.danielbechler.diff.node.Node;
import de.danielbechler.diff.visitor.Visit;
import de.danielbechler.util.Strings;

public class NodeHierarchyVisitor
implements Node.Visitor {
    public static final int UNLIMITED = -1;
    private final int maxDepth;

    public NodeHierarchyVisitor() {
        this(-1);
    }

    public NodeHierarchyVisitor(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public void accept(Node node, Visit visit) {
        if (this.maxDepth == 0) {
            visit.stop();
        }
        int currentLevel = NodeHierarchyVisitor.calculateDepth(node);
        if (this.maxDepth > 0) {
            if (currentLevel <= this.maxDepth) {
                this.print(node, currentLevel);
            } else {
                visit.dontGoDeeper();
            }
        } else if (this.maxDepth < 0) {
            this.print(node, currentLevel);
        }
    }

    protected void print(Node node, int level) {
        String nodeAsString = node.getPropertyPath() + " ===> " + node.toString();
        String indentedNodeString = Strings.indent(level, nodeAsString);
        this.print(indentedNodeString);
    }

    protected void print(String text) {
        System.out.println(text);
    }

    private static int calculateDepth(Node node) {
        int count = 0;
        Node parentNode = node.getParentNode();
        while (parentNode != null) {
            ++count;
            parentNode = parentNode.getParentNode();
        }
        return count;
    }
}

