/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.differ;

import de.danielbechler.diff.access.Accessor;
import de.danielbechler.diff.access.CollectionItemAccessor;
import de.danielbechler.diff.access.Instances;
import de.danielbechler.diff.comparison.ComparisonStrategy;
import de.danielbechler.diff.comparison.ComparisonStrategyResolver;
import de.danielbechler.diff.differ.Differ;
import de.danielbechler.diff.differ.DifferDispatcher;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.util.Assert;
import de.danielbechler.util.Collections;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionDiffer
implements Differ {
    private final DifferDispatcher differDispatcher;
    private final ComparisonStrategyResolver comparisonStrategyResolver;

    public CollectionDiffer(DifferDispatcher differDispatcher, ComparisonStrategyResolver comparisonStrategyResolver) {
        Assert.notNull(differDispatcher, "differDispatcher");
        this.differDispatcher = differDispatcher;
        Assert.notNull(comparisonStrategyResolver, "comparisonStrategyResolver");
        this.comparisonStrategyResolver = comparisonStrategyResolver;
    }

    private static void compareUsingComparisonStrategy(DiffNode collectionNode, Instances collectionInstances, ComparisonStrategy comparisonStrategy) {
        comparisonStrategy.compare(collectionNode, collectionInstances.getType(), collectionInstances.getWorking(Collection.class), collectionInstances.getBase(Collection.class));
    }

    private static DiffNode newNode(DiffNode parentNode, Instances collectionInstances) {
        Accessor accessor = collectionInstances.getSourceAccessor();
        Class<?> type = collectionInstances.getType();
        return new DiffNode(parentNode, accessor, type);
    }

    private static Collection<?> addedItemsOf(Instances instances) {
        Collection working = instances.getWorking(Collection.class);
        Collection base = instances.getBase(Collection.class);
        return Collections.filteredCopyOf(working, base);
    }

    private static Collection<?> removedItemsOf(Instances instances) {
        Collection working = instances.getWorking(Collection.class);
        Collection base = instances.getBase(Collection.class);
        return Collections.filteredCopyOf(base, working);
    }

    private static Iterable<?> knownItemsOf(Instances instances) {
        Collection working = instances.getWorking(Collection.class);
        ArrayList changed = new ArrayList(working);
        changed.removeAll(CollectionDiffer.addedItemsOf(instances));
        changed.removeAll(CollectionDiffer.removedItemsOf(instances));
        return changed;
    }

    @Override
    public boolean accepts(Class<?> type) {
        return Collection.class.isAssignableFrom(type);
    }

    @Override
    public final DiffNode compare(DiffNode parentNode, Instances collectionInstances) {
        DiffNode collectionNode = CollectionDiffer.newNode(parentNode, collectionInstances);
        if (collectionInstances.hasBeenAdded()) {
            Collection addedItems = collectionInstances.getWorking(Collection.class);
            this.compareItems(collectionNode, collectionInstances, addedItems);
            collectionNode.setState(DiffNode.State.ADDED);
        } else if (collectionInstances.hasBeenRemoved()) {
            Collection removedItems = collectionInstances.getBase(Collection.class);
            this.compareItems(collectionNode, collectionInstances, removedItems);
            collectionNode.setState(DiffNode.State.REMOVED);
        } else if (collectionInstances.areSame()) {
            collectionNode.setState(DiffNode.State.UNTOUCHED);
        } else {
            ComparisonStrategy comparisonStrategy = this.comparisonStrategyResolver.resolveComparisonStrategy(collectionNode);
            if (comparisonStrategy == null) {
                this.compareInternally(collectionNode, collectionInstances);
            } else {
                CollectionDiffer.compareUsingComparisonStrategy(collectionNode, collectionInstances, comparisonStrategy);
            }
        }
        return collectionNode;
    }

    private void compareInternally(DiffNode collectionNode, Instances collectionInstances) {
        this.compareItems(collectionNode, collectionInstances, CollectionDiffer.addedItemsOf(collectionInstances));
        this.compareItems(collectionNode, collectionInstances, CollectionDiffer.removedItemsOf(collectionInstances));
        this.compareItems(collectionNode, collectionInstances, CollectionDiffer.knownItemsOf(collectionInstances));
    }

    private void compareItems(DiffNode collectionNode, Instances collectionInstances, Iterable<?> items) {
        for (Object item : items) {
            CollectionItemAccessor itemAccessor = new CollectionItemAccessor(item);
            this.differDispatcher.dispatch(collectionNode, collectionInstances, itemAccessor);
        }
    }
}

