/*
 * Decompiled with CFR 0.152.
 */
package de.fxlae.typeid;

import de.fxlae.typeid.lib.TypeIdLib;
import de.fxlae.typeid.util.Validated;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

public record TypeId(String prefix, UUID uuid) {
    public TypeId {
        TypeIdLib.requireValidPrefix(prefix);
        Objects.requireNonNull(uuid);
    }

    public static TypeId generate(String prefix) {
        return TypeId.of(prefix, TypeIdLib.getUuidV7());
    }

    public static TypeId generate() {
        return TypeId.of("", TypeIdLib.getUuidV7());
    }

    public static TypeId of(UUID uuid) {
        return TypeId.of("", uuid);
    }

    public static TypeId of(String prefix, UUID uuid) {
        return new TypeId(prefix, uuid);
    }

    public static TypeId parse(String text) {
        return TypeIdLib.parse(text, TypeId::of, (String message) -> {
            throw new IllegalArgumentException((String)message);
        });
    }

    public static <T> T parse(String text, Function<TypeId, T> successHandler, Function<String, T> errorHandler) {
        return (T)TypeIdLib.parse(text, (String prefix, UUID uuid) -> successHandler.apply(TypeId.of(prefix, uuid)), errorHandler);
    }

    public static Optional<TypeId> parseToOptional(String text) {
        return TypeIdLib.parse(text, (String prefix, UUID uuid) -> Optional.of(TypeId.of(prefix, uuid)), (String error) -> Optional.empty());
    }

    public static Validated<TypeId> parseToValidated(String text) {
        return TypeIdLib.parse(text, (String prefix, UUID uuid) -> Validated.valid(TypeId.of(prefix, uuid)), Validated::invalid);
    }

    @Override
    public String toString() {
        return TypeIdLib.encode(this.prefix, this.uuid);
    }
}

