/*
 * Decompiled with CFR 0.152.
 */
package de.fxlae.typeid.lib;

import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.TimeBasedEpochGenerator;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class TypeIdLib {
    public static final String VALID_REF = "";
    private static final char SEPARATOR = '_';
    private static final int PREFIX_MAX_LENGTH = 63;
    private static final String SUFFIX_ALPHABET = "0123456789abcdefghjkmnpqrstvwxyz";
    private static final int SUFFIX_LENGTH = 26;
    private static final long NOOP = Long.MAX_VALUE;
    private static final long[] SUFFIX_LOOKUP = new long[]{Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, Long.MAX_VALUE, 18L, 19L, Long.MAX_VALUE, 20L, 21L, Long.MAX_VALUE, 22L, 23L, 24L, 25L, 26L, Long.MAX_VALUE, 27L, 28L, 29L, 30L, 31L, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE};
    private static final TimeBasedEpochGenerator generator = Generators.timeBasedEpochGenerator();

    private TypeIdLib() {
    }

    private static UUID decodeSuffixOnInput(String input, int separatorIndex) {
        int start = separatorIndex == -1 ? 0 : separatorIndex + 1;
        long lsb = 0L;
        long msb = 0L;
        lsb |= SUFFIX_LOOKUP[input.charAt(25 + start)];
        lsb |= SUFFIX_LOOKUP[input.charAt(24 + start)] << 5;
        lsb |= SUFFIX_LOOKUP[input.charAt(23 + start)] << 10;
        lsb |= SUFFIX_LOOKUP[input.charAt(22 + start)] << 15;
        lsb |= SUFFIX_LOOKUP[input.charAt(21 + start)] << 20;
        lsb |= SUFFIX_LOOKUP[input.charAt(20 + start)] << 25;
        lsb |= SUFFIX_LOOKUP[input.charAt(19 + start)] << 30;
        lsb |= SUFFIX_LOOKUP[input.charAt(18 + start)] << 35;
        lsb |= SUFFIX_LOOKUP[input.charAt(17 + start)] << 40;
        lsb |= SUFFIX_LOOKUP[input.charAt(16 + start)] << 45;
        lsb |= SUFFIX_LOOKUP[input.charAt(15 + start)] << 50;
        lsb |= SUFFIX_LOOKUP[input.charAt(14 + start)] << 55;
        long bitsAtOverlap = SUFFIX_LOOKUP[input.charAt(13 + start)];
        lsb |= (bitsAtOverlap & 0xFL) << 60;
        msb |= (bitsAtOverlap & 0x10L) >>> 4;
        msb |= SUFFIX_LOOKUP[input.charAt(12 + start)] << 1;
        msb |= SUFFIX_LOOKUP[input.charAt(11 + start)] << 6;
        msb |= SUFFIX_LOOKUP[input.charAt(10 + start)] << 11;
        msb |= SUFFIX_LOOKUP[input.charAt(9 + start)] << 16;
        msb |= SUFFIX_LOOKUP[input.charAt(8 + start)] << 21;
        msb |= SUFFIX_LOOKUP[input.charAt(7 + start)] << 26;
        msb |= SUFFIX_LOOKUP[input.charAt(6 + start)] << 31;
        msb |= SUFFIX_LOOKUP[input.charAt(5 + start)] << 36;
        msb |= SUFFIX_LOOKUP[input.charAt(4 + start)] << 41;
        msb |= SUFFIX_LOOKUP[input.charAt(3 + start)] << 46;
        msb |= SUFFIX_LOOKUP[input.charAt(2 + start)] << 51;
        msb |= SUFFIX_LOOKUP[input.charAt(1 + start)] << 56;
        return new UUID(msb |= SUFFIX_LOOKUP[input.charAt(start)] << 61, lsb);
    }

    public static String encode(String prefix, UUID uuid) {
        StringBuilder sb;
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        if (prefix.isEmpty()) {
            sb = new StringBuilder(26);
        } else {
            sb = new StringBuilder(27 + prefix.length());
            sb.append(prefix).append('_');
        }
        sb.append(SUFFIX_ALPHABET.charAt((int)(msb >>> 61) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(msb >>> 56) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(msb >>> 51) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(msb >>> 46) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(msb >>> 41) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(msb >>> 36) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(msb >>> 31) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(msb >>> 26) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(msb >>> 21) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(msb >>> 16) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(msb >>> 11) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(msb >>> 6) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(msb >>> 1) & 0x1F));
        long overlap = (msb & 1L) << 4 | lsb >>> 60;
        sb.append(SUFFIX_ALPHABET.charAt((int)overlap));
        sb.append(SUFFIX_ALPHABET.charAt((int)(lsb >>> 55) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(lsb >>> 50) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(lsb >>> 45) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(lsb >>> 40) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(lsb >>> 35) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(lsb >>> 30) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(lsb >>> 25) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(lsb >>> 20) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(lsb >>> 15) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(lsb >>> 10) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)(lsb >>> 5) & 0x1F)).append(SUFFIX_ALPHABET.charAt((int)lsb & 0x1F));
        return sb.toString();
    }

    public static <T> T parse(String text, BiFunction<String, UUID, T> successHandler, Function<String, T> errorHandler) {
        Objects.requireNonNull(successHandler);
        Objects.requireNonNull(errorHandler);
        if (text == null || text.isEmpty()) {
            return errorHandler.apply("Provided TypeId must not be null or empty");
        }
        int separatorIndex = text.lastIndexOf(95);
        if (separatorIndex == 0) {
            return errorHandler.apply("TypeId with empty prefix must not contain the separator '_'");
        }
        String suffixValidation = TypeIdLib.validateSuffixOnInput(text, separatorIndex);
        if (suffixValidation != VALID_REF) {
            return errorHandler.apply(suffixValidation);
        }
        String prefixValidation = TypeIdLib.validatePrefixOnInput(text, separatorIndex);
        if (prefixValidation != VALID_REF) {
            return errorHandler.apply(prefixValidation);
        }
        return successHandler.apply(TypeIdLib.extractPrefix(text, separatorIndex), TypeIdLib.decodeSuffixOnInput(text, separatorIndex));
    }

    private static String extractPrefix(String input, int separatorIndex) {
        if (separatorIndex == -1) {
            return VALID_REF;
        }
        return input.substring(0, separatorIndex);
    }

    private static String validateSuffixOnInput(String input, int separatorIndex) {
        int start;
        int n = start = separatorIndex != -1 ? separatorIndex + 1 : 0;
        if (input.length() - start != 26) {
            return "Suffix with illegal length, must be 26";
        }
        char firstChar = input.charAt(start);
        if (firstChar < '0' || firstChar > '7') {
            return "Illegal leftmost suffix character, must be one of [01234567]";
        }
        for (int i = start; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c < SUFFIX_LOOKUP.length && SUFFIX_LOOKUP[c] != Long.MAX_VALUE) continue;
            return "Illegal character in suffix, must be one of [0123456789abcdefghjkmnpqrstvwxyz]";
        }
        return VALID_REF;
    }

    public static void requireValidPrefix(String prefix) {
        Objects.requireNonNull(prefix);
        if (prefix.isEmpty()) {
            return;
        }
        String prefixValidation = TypeIdLib.validatePrefixOnInput(prefix, prefix.length());
        if (prefixValidation != VALID_REF) {
            throw new IllegalArgumentException(prefixValidation);
        }
    }

    private static String validatePrefixOnInput(String input, int separatorIndex) {
        if (separatorIndex == -1) {
            return VALID_REF;
        }
        if (separatorIndex > 63) {
            return "Prefix with illegal length, must not have more than 63 characters";
        }
        if (input.charAt(0) == '_' || input.charAt(separatorIndex - 1) == '_') {
            return "Prefix must not start or end with '_'";
        }
        for (int i = 0; i < separatorIndex; ++i) {
            char c = input.charAt(i);
            if (c >= 'a' && c <= 'z' || c == '_') continue;
            return "Illegal character in prefix, must be one of [a-z_]";
        }
        return VALID_REF;
    }

    public static UUID getUuidV7() {
        return generator.generate();
    }
}

