/*
 * Decompiled with CFR 0.152.
 */
package de.fxlae.typeid.util;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Validated<T> {
    public static <T> Validated<T> valid(T value) {
        return new Valid<T>(Objects.requireNonNull(value));
    }

    public static <T> Validated<T> invalid(String message) {
        return new Invalid(Objects.requireNonNull(message));
    }

    public Optional<T> toOptional();

    public boolean isValid();

    public T get();

    public T orElse(T var1);

    public String message();

    public <O> Validated<O> map(Function<? super T, ? extends O> var1);

    public <O> Validated<O> flatMap(Function<? super T, Validated<O>> var1);

    public Validated<T> filter(String var1, Predicate<? super T> var2);

    public void ifValid(Consumer<T> var1);

    public void ifInvalid(Consumer<String> var1);

    public record Valid<T>(T value) implements Validated<T>
    {
        public Valid {
            Objects.requireNonNull(value);
        }

        @Override
        public Optional<T> toOptional() {
            return Optional.of(this.value);
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public T orElse(T other) {
            return this.value;
        }

        @Override
        public String message() {
            throw new NoSuchElementException("no message, element is valid");
        }

        @Override
        public <O> Validated<O> map(Function<? super T, ? extends O> mapper) {
            Objects.requireNonNull(mapper);
            return Validated.valid(mapper.apply(this.value));
        }

        @Override
        public <O> Validated<O> flatMap(Function<? super T, Validated<O>> mapper) {
            Objects.requireNonNull(mapper);
            return mapper.apply(this.value);
        }

        @Override
        public Validated<T> filter(String message, Predicate<? super T> predicate) {
            Objects.requireNonNull(message);
            Objects.requireNonNull(predicate);
            if (predicate.test(this.value)) {
                return this;
            }
            return Validated.invalid(message);
        }

        @Override
        public void ifValid(Consumer<T> valueConsumer) {
            Objects.requireNonNull(valueConsumer);
            valueConsumer.accept(this.value);
        }

        @Override
        public void ifInvalid(Consumer<String> messageConsumer) {
            Objects.requireNonNull(messageConsumer);
        }
    }

    public record Invalid<T>(String message) implements Validated<T>
    {
        public Invalid {
            Objects.requireNonNull(message);
        }

        @Override
        public Optional<T> toOptional() {
            return Optional.empty();
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public T get() {
            throw new NoSuchElementException("Validation failed: " + this.message);
        }

        @Override
        public T orElse(T other) {
            return other;
        }

        @Override
        public <O> Validated<O> map(Function<? super T, ? extends O> mapper) {
            Objects.requireNonNull(mapper);
            return Validated.invalid(this.message);
        }

        @Override
        public <O> Validated<O> flatMap(Function<? super T, Validated<O>> mapper) {
            Objects.requireNonNull(mapper);
            return Validated.invalid(this.message);
        }

        @Override
        public Validated<T> filter(String message, Predicate<? super T> predicate) {
            Objects.requireNonNull(message);
            Objects.requireNonNull(predicate);
            return this;
        }

        @Override
        public void ifValid(Consumer<T> valueConsumer) {
            Objects.requireNonNull(valueConsumer);
        }

        @Override
        public void ifInvalid(Consumer<String> messageConsumer) {
            Objects.requireNonNull(messageConsumer);
            messageConsumer.accept(this.message);
        }
    }
}

