/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.python3;

import de.jplag.AbstractParser;
import de.jplag.ParsingException;
import de.jplag.Token;
import de.jplag.TokenType;
import de.jplag.python3.JplagPython3Listener;
import de.jplag.python3.grammar.Python3Lexer;
import de.jplag.python3.grammar.Python3Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class Parser
extends AbstractParser {
    private List<Token> tokens;
    private File currentFile;

    public List<Token> parse(Set<File> files) throws ParsingException {
        this.tokens = new ArrayList<Token>();
        for (File file : files) {
            this.logger.trace("Parsing file {}", (Object)file.getName());
            this.parseFile(file);
            this.tokens.add(Token.fileEnd((File)file));
        }
        return this.tokens;
    }

    private void parseFile(File file) throws ParsingException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.currentFile = file;
            Python3Lexer lexer = new Python3Lexer(CharStreams.fromStream((InputStream)fileInputStream));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            Python3Parser parser = new Python3Parser((TokenStream)tokens);
            Python3Parser.File_inputContext in = parser.file_input();
            ParseTreeWalker ptw = new ParseTreeWalker();
            for (int i = 0; i < in.getChildCount(); ++i) {
                ParseTree pt = in.getChild(i);
                ptw.walk((ParseTreeListener)new JplagPython3Listener(this), pt);
            }
        }
        catch (IOException e) {
            throw new ParsingException(file, e.getMessage(), (Throwable)e);
        }
    }

    public void add(TokenType type, org.antlr.v4.runtime.Token token) {
        this.tokens.add(new Token(type, this.currentFile, token.getLine(), token.getCharPositionInLine() + 1, token.getText().length()));
    }

    public void addEnd(TokenType type, org.antlr.v4.runtime.Token token) {
        this.tokens.add(new Token(type, this.currentFile, token.getLine(), this.tokens.get(this.tokens.size() - 1).getColumn() + 1, 0));
    }
}

