/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.python3.grammar;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Token;

abstract class Python3LexerBase
extends Lexer {
    private LinkedList<Token> tokens = new LinkedList();
    private Deque<Integer> indents = new ArrayDeque<Integer>();
    private int opened = 0;
    private Token lastToken = null;

    protected Python3LexerBase(CharStream input) {
        super(input);
    }

    public void emit(Token t) {
        super.setToken(t);
        this.tokens.offer(t);
    }

    public Token nextToken() {
        Token next;
        if (this._input.LA(1) == -1 && !this.indents.isEmpty()) {
            for (int i = this.tokens.size() - 1; i >= 0; --i) {
                if (this.tokens.get(i).getType() != -1) continue;
                this.tokens.remove(i);
            }
            this.emit((Token)this.commonToken(44, "\n"));
            while (!this.indents.isEmpty()) {
                this.emit(this.createDedent());
                this.indents.pop();
            }
            this.emit((Token)this.commonToken(-1, "<EOF>"));
        }
        if ((next = super.nextToken()).getChannel() == 0) {
            this.lastToken = next;
        }
        return this.tokens.isEmpty() ? next : this.tokens.poll();
    }

    private Token createDedent() {
        CommonToken dedent = this.commonToken(2, "");
        dedent.setLine(this.lastToken.getLine());
        return dedent;
    }

    private CommonToken commonToken(int type, String text) {
        int stop = this.getCharIndex() - 1;
        int start = text.isEmpty() ? stop : stop - text.length() + 1;
        return new CommonToken(this._tokenFactorySourcePair, type, 0, start, stop);
    }

    static int getIndentationCount(String spaces) {
        int count = 0;
        block3: for (char ch : spaces.toCharArray()) {
            switch (ch) {
                case '\t': {
                    count += 8 - count % 8;
                    continue block3;
                }
                default: {
                    ++count;
                }
            }
        }
        return count;
    }

    boolean atStartOfInput() {
        return super.getCharPositionInLine() == 0 && super.getLine() == 1;
    }

    void openBrace() {
        ++this.opened;
    }

    void closeBrace() {
        --this.opened;
    }

    void onNewLine() {
        String newLine = this.getText().replaceAll("[^\r\n\f]+", "");
        String spaces = this.getText().replaceAll("[\r\n\f]+", "");
        int next = this._input.LA(1);
        int nextnext = this._input.LA(2);
        if (this.opened > 0 || nextnext != -1 && (next == 13 || next == 10 || next == 12 || next == 35)) {
            this.skip();
        } else {
            int previous;
            this.emit((Token)this.commonToken(44, newLine));
            int indent = Python3LexerBase.getIndentationCount(spaces);
            int n = previous = this.indents.isEmpty() ? 0 : this.indents.peek();
            if (indent == previous) {
                this.skip();
            } else if (indent > previous) {
                this.indents.push(indent);
                this.emit((Token)this.commonToken(1, spaces));
            } else {
                while (!this.indents.isEmpty() && this.indents.peek() > indent) {
                    this.emit(this.createDedent());
                    this.indents.pop();
                }
            }
        }
    }

    public void reset() {
        this.tokens = new LinkedList();
        this.indents = new ArrayDeque<Integer>();
        this.opened = 0;
        this.lastToken = null;
        super.reset();
    }
}

