/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.features.observationtable;

import de.learnlib.algorithms.features.observationtable.InvalidRowException;
import de.learnlib.algorithms.features.observationtable.NoSuchRowException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.Signed;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public interface ObservationTable<I, O> {
    public static final int NO_DISTINGUISHING_SUFFIX = -1;

    @Nonnull
    public Collection<? extends Word<I>> getShortPrefixes();

    @Nonnull
    public Collection<? extends Word<I>> getLongPrefixes();

    @Nonnull
    public Collection<? extends Word<I>> getAllPrefixes();

    @Nonnull
    public List<? extends Word<I>> getSuffixes();

    @Nonnull
    public Word<I> getSuffix(@Nonnegative int var1) throws IndexOutOfBoundsException;

    @Nonnull
    public Collection<? extends Row<I, O>> getShortPrefixRows();

    @Nonnull
    public Collection<? extends Row<I, O>> getLongPrefixRows();

    @Nonnull
    public Collection<? extends Row<I, O>> getAllRows();

    @Nonnull
    public Row<I, O> getRow(Word<I> var1) throws NoSuchRowException;

    @Nullable
    public Row<I, O> getSuccessorRow(Row<I, O> var1, @Nullable I var2) throws InvalidRowException;

    public boolean isClosed();

    @Nullable
    public Row<I, O> findUnclosedRow();

    public boolean isConsistent(Collection<? extends I> var1);

    @Nullable
    public Inconsistency<I, O> findInconsistency(Collection<? extends I> var1);

    @Signed
    public int findDistinguishingSuffixIndex(Inconsistency<I, O> var1) throws NoSuchRowException, InvalidRowException;

    @Nullable
    public Word<I> findDistinguishingSuffix(Inconsistency<I, O> var1) throws NoSuchRowException, InvalidRowException;

    @Signed
    public int findDistinguishingSuffixIndex(Row<I, O> var1, Row<I, O> var2) throws InvalidRowException;

    @Nullable
    public Word<I> findDistinguishingSuffix(Row<I, O> var1, Row<I, O> var2) throws InvalidRowException;

    public static interface Inconsistency<I, O> {
        @Nonnull
        public Row<I, O> getFirstRow();

        @Nonnull
        public Row<I, O> getSecondRow();

        @Nullable
        public I getSymbol();
    }

    public static interface Row<I, O>
    extends Iterable<O> {
        @Nonnull
        public Word<I> getLabel();

        public boolean isShortPrefixRow();

        @Nonnull
        public List<? extends O> getContents();

        public int size();

        @Nullable
        public O getCellContent(@Nonnegative int var1) throws IndexOutOfBoundsException;
    }
}

