/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.features.observationtable.writer;

import com.google.common.base.Function;
import de.learnlib.algorithms.features.observationtable.ObservationTable;
import de.learnlib.algorithms.features.observationtable.writer.AbstractObservationTableWriter;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import net.automatalib.words.Word;

public class SuffixASCIIWriter<I, O>
extends AbstractObservationTableWriter<I, O> {
    private static final String WORD_DELIMITER = ";";
    private static final String SYMBOL_DELIMITER = ",";

    public SuffixASCIIWriter() {
        Function wordToString = new Function<Word<? extends I>, String>(){

            @Nullable
            public String apply(@Nullable Word<? extends I> is) {
                if (is == null) {
                    return "";
                }
                boolean first = true;
                StringBuilder sb = new StringBuilder();
                for (Object symbol : is) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(SuffixASCIIWriter.SYMBOL_DELIMITER);
                    }
                    String stringRepresentation = symbol.toString();
                    if (stringRepresentation.contains(SuffixASCIIWriter.SYMBOL_DELIMITER) || stringRepresentation.contains(SuffixASCIIWriter.WORD_DELIMITER)) {
                        throw new IllegalArgumentException("Symbol '" + stringRepresentation + "' must not contain " + "delimiters '" + SuffixASCIIWriter.SYMBOL_DELIMITER + "' or '" + SuffixASCIIWriter.WORD_DELIMITER + '\'');
                    }
                    sb.append(symbol.toString());
                }
                return sb.toString();
            }
        };
        super.setWordToString(wordToString);
    }

    @Override
    public void write(ObservationTable<? extends I, ? extends O> table, @WillNotClose Appendable out) throws IOException {
        List<Word<I>> suffixes = table.getSuffixes();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Word<I> word : suffixes) {
            if (first) {
                first = false;
            } else {
                sb.append(WORD_DELIMITER);
            }
            String stringRepresentation = this.wordToString(word);
            if (stringRepresentation.contains(WORD_DELIMITER)) {
                throw new IllegalArgumentException("Delimiter ';' must not be used in symbol names. Symbol containing the delimiter was '" + stringRepresentation + '\'');
            }
            sb.append(stringRepresentation);
        }
        out.append(sb.toString());
    }
}

