/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.eqtests.basic;

import de.learnlib.api.EquivalenceOracle;
import de.learnlib.api.MembershipOracle;
import de.learnlib.oracles.DefaultQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.concepts.Output;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.util.automata.Automata;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class WMethodEQOracle<A extends UniversalDeterministicAutomaton<?, I, ?, ?, ?> & Output<I, O>, I, O>
implements EquivalenceOracle<A, I, O> {
    private int maxDepth;
    private final MembershipOracle<I, O> sulOracle;

    public WMethodEQOracle(int maxDepth, MembershipOracle<I, O> sulOracle) {
        this.maxDepth = maxDepth;
        this.sulOracle = sulOracle;
    }

    public DefaultQuery<I, O> findCounterExample(A hypothesis, Collection<? extends I> inputs) {
        List transCover = Automata.transitionCover(hypothesis, inputs);
        List<Word> charSuffixes = Automata.characterizingSet(hypothesis, inputs);
        if (charSuffixes.isEmpty()) {
            charSuffixes = Collections.singletonList(Word.epsilon());
        }
        WordBuilder wb = new WordBuilder();
        for (List middle : CollectionsUtil.allTuples(inputs, (int)1, (int)this.maxDepth)) {
            for (Word trans : transCover) {
                for (Word suffix : charSuffixes) {
                    wb.append(trans).append(middle).append(suffix);
                    Word queryWord = wb.toWord();
                    wb.clear();
                    DefaultQuery query = new DefaultQuery(queryWord);
                    Object hypOutput = ((Output)hypothesis).computeOutput((Iterable)queryWord);
                    this.sulOracle.processQueries(Collections.singleton(query));
                    if (Objects.equals(hypOutput, query.getOutput())) continue;
                    return query;
                }
            }
        }
        return null;
    }
}

