/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.eqtests.basic;

import de.learnlib.api.EquivalenceOracle;
import de.learnlib.api.MembershipOracle;
import de.learnlib.oracles.DefaultQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.concepts.Output;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.util.automata.Automata;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class WpMethodEQOracle<A extends UniversalDeterministicAutomaton<?, I, ?, ?, ?> & Output<I, O>, I, O>
implements EquivalenceOracle<A, I, O> {
    private final int maxDepth;
    private final MembershipOracle<I, O> sulOracle;

    public WpMethodEQOracle(int maxDepth, MembershipOracle<I, O> sulOracle) {
        this.maxDepth = maxDepth;
        this.sulOracle = sulOracle;
    }

    public DefaultQuery<I, O> findCounterExample(A hypothesis, Collection<? extends I> inputs) {
        A aut = hypothesis;
        Output out = (Output)hypothesis;
        return this.doFindCounterExample((UniversalDeterministicAutomaton)aut, (Output<I, O>)out, inputs);
    }

    private <S> DefaultQuery<I, O> doFindCounterExample(UniversalDeterministicAutomaton<S, I, ?, ?, ?> hypothesis, Output<I, O> output, Collection<? extends I> inputs) {
        ArrayList stateCover = new ArrayList(hypothesis.size());
        ArrayList transitions = new ArrayList(hypothesis.size() * (inputs.size() - 1));
        Automata.cover(hypothesis, inputs, stateCover, transitions);
        List<Word> globalSuffixes = Automata.characterizingSet(hypothesis, inputs);
        if (globalSuffixes.isEmpty()) {
            globalSuffixes = Collections.singletonList(Word.epsilon());
        }
        WordBuilder wb = new WordBuilder();
        for (List middle : CollectionsUtil.allTuples(inputs, (int)1, (int)this.maxDepth)) {
            for (Word as : stateCover) {
                for (Word suffix : globalSuffixes) {
                    wb.append(as).append(middle).append(suffix);
                    Word queryWord = wb.toWord();
                    wb.clear();
                    DefaultQuery query = new DefaultQuery(queryWord);
                    Object hypOutput = output.computeOutput((Iterable)queryWord);
                    this.sulOracle.processQueries(Collections.singleton(query));
                    if (Objects.equals(hypOutput, query.getOutput())) continue;
                    return query;
                }
            }
        }
        MutableMapping localSuffixSets = hypothesis.createStaticStateMapping();
        for (List middle : CollectionsUtil.allTuples(inputs, (int)1, (int)this.maxDepth)) {
            for (Word trans : transitions) {
                Object state = hypothesis.getState((Iterable)trans);
                List localSuffixes = (List)localSuffixSets.get(state);
                if (localSuffixes == null) {
                    localSuffixes = Automata.stateCharacterizingSet(hypothesis, inputs, (Object)state);
                    if (localSuffixes.isEmpty()) {
                        localSuffixes = Collections.singletonList(Word.epsilon());
                    }
                    localSuffixSets.put(state, localSuffixes);
                }
                for (Word suffix : localSuffixes) {
                    wb.append(trans).append(middle).append(suffix);
                    Word queryWord = wb.toWord();
                    wb.clear();
                    DefaultQuery query = new DefaultQuery(queryWord);
                    Object hypOutput = output.computeOutput((Iterable)queryWord);
                    this.sulOracle.processQueries(Collections.singleton(query));
                    if (Objects.equals(hypOutput, query.getOutput())) continue;
                    return query;
                }
            }
        }
        return null;
    }
}

