/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.eqtests.basic.mealy;

import de.learnlib.api.EquivalenceOracle;
import de.learnlib.api.SUL;
import de.learnlib.oracles.DefaultQuery;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class RandomWalkEQOracle<I, O>
implements EquivalenceOracle<MealyMachine<?, I, ?, O>, I, Word<O>> {
    private final double restartProbability;
    private final long maxSteps;
    private long steps = 0L;
    private boolean resetStepCount;
    private final Random random;
    private final SUL<I, O> sul;

    public RandomWalkEQOracle(double restartProbability, long maxSteps, Random random, SUL<I, O> sul) {
        this.restartProbability = restartProbability;
        this.maxSteps = maxSteps;
        this.random = random;
        this.sul = sul;
    }

    public RandomWalkEQOracle(double restartProbability, long maxSteps, boolean resetStepCount, Random random, SUL<I, O> sul) {
        this(restartProbability, maxSteps, random, sul);
        this.resetStepCount = resetStepCount;
    }

    public DefaultQuery<I, Word<O>> findCounterExample(MealyMachine<?, I, ?, O> hypothesis, Collection<? extends I> inputs) {
        return this.doFindCounterExample(hypothesis, inputs);
    }

    private <S, T> DefaultQuery<I, Word<O>> doFindCounterExample(MealyMachine<S, I, T, O> hypothesis, Collection<? extends I> inputs) {
        if (this.resetStepCount) {
            this.steps = 0L;
        }
        List choices = CollectionsUtil.randomAccessList(inputs);
        int bound = choices.size();
        Object cur = hypothesis.getInitialState();
        WordBuilder wbIn = new WordBuilder();
        WordBuilder wbOut = new WordBuilder();
        while (this.steps < this.maxSteps) {
            double restart = this.random.nextDouble();
            if (restart < this.restartProbability) {
                this.sul.reset();
                cur = hypothesis.getInitialState();
                wbIn.clear();
                wbOut.clear();
            }
            ++this.steps;
            Object in = choices.get(this.random.nextInt(bound));
            Object outSul = this.sul.step(in);
            Object hypTrans = hypothesis.getTransition(cur, in);
            Object outHyp = hypothesis.getTransitionOutput(hypTrans);
            wbIn.add(in);
            wbOut.add(outSul);
            if (!outSul.equals(outHyp)) {
                DefaultQuery ce = new DefaultQuery(wbIn.toWord());
                ce.answer((Object)wbOut.toWord());
                return ce;
            }
            cur = hypothesis.getSuccessor(cur, in);
        }
        return null;
    }
}

