/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.eqtests.basic.mealy;

import de.learnlib.api.EquivalenceOracle;
import de.learnlib.oracles.DefaultQuery;
import java.util.Collection;
import java.util.Objects;
import net.automatalib.automata.concepts.SODetOutputAutomaton;
import net.automatalib.words.Word;

public class SymbolEQOracleWrapper<A extends SODetOutputAutomaton<?, I, ?, Word<O>>, I, O>
implements EquivalenceOracle<A, I, O> {
    private final EquivalenceOracle<? super A, I, Word<O>> wordEqOracle;

    public SymbolEQOracleWrapper(EquivalenceOracle<? super A, I, Word<O>> wordEqOracle) {
        this.wordEqOracle = wordEqOracle;
    }

    public DefaultQuery<I, O> findCounterExample(A hypothesis, Collection<? extends I> inputs) {
        DefaultQuery wordCeQry = this.wordEqOracle.findCounterExample(hypothesis, inputs);
        if (wordCeQry == null) {
            return null;
        }
        Word hypOut = (Word)hypothesis.computeSuffixOutput((Iterable)wordCeQry.getPrefix(), (Iterable)wordCeQry.getSuffix());
        Word ceOut = (Word)wordCeQry.getOutput();
        int len = hypOut.length();
        if (len != ceOut.length()) {
            throw new IllegalStateException("Output word length does not align with suffix length, truncating CE will not work");
        }
        for (int i = 0; i < len; ++i) {
            Object ceSym;
            Object hypSym = hypOut.getSymbol(i);
            if (Objects.equals(hypSym, ceSym = ceOut.getSymbol(i))) continue;
            DefaultQuery result = new DefaultQuery(wordCeQry.getPrefix(), wordCeQry.getSuffix().prefix(i + 1));
            result.answer(ceSym);
            return result;
        }
        throw new IllegalStateException("Counterexample returned by underlying EQ oracle was none");
    }
}

