/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.javascript;

import de.matrixweb.smaller.common.SmallerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.commonjs.module.ModuleScope;
import org.mozilla.javascript.commonjs.module.ModuleScript;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.Require;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaScriptExecutor.class);
    private boolean initializing = true;
    private final String name;
    private final int optimizationLevel;
    private ModuleScope moduleScope;
    private String source;

    public JavaScriptExecutor(String name) {
        this(name, 9, JavaScriptException.class);
    }

    public JavaScriptExecutor(String name, Class<?> clazz) {
        this(name, 9, clazz);
    }

    public JavaScriptExecutor(String name, int optimizationLevel) {
        this(name, optimizationLevel, JavaScriptException.class);
    }

    public JavaScriptExecutor(String name, int optimizationLevel, Class<?> clazz) {
        this.name = name;
        this.optimizationLevel = optimizationLevel;
        this.init(clazz);
    }

    private void init(Class<?> clazz) {
        Context context = Context.enter();
        context.setOptimizationLevel(this.optimizationLevel);
        context.setLanguageVersion(180);
        ScriptableObject scope = context.initStandardObjects();
        Require require = new Require(Context.getCurrentContext(), (Scriptable)scope, this.getModuleScriptProvider(clazz), null, null, false);
        require.install((Scriptable)scope);
        try {
            this.moduleScope = new ModuleScope((Scriptable)scope, new URI("./" + this.name), null);
        }
        catch (URISyntaxException e) {
            throw new SmallerException("Failed to create moduleScope", (Throwable)e);
        }
        this.addProperty("logger", LOGGER);
    }

    public final void addProperty(String name, Object object) {
        ScriptableObject.putProperty((Scriptable)this.moduleScope, (String)name, (Object)Context.javaToJS((Object)object, (Scriptable)this.moduleScope));
    }

    public void addScriptSource(String source, String name) {
        Context.getCurrentContext().evaluateString((Scriptable)this.moduleScope, source, name, 1, null);
    }

    public void addScriptFile(String file) {
        try {
            InputStream script = this.getClass().getResourceAsStream(file);
            try {
                Context.getCurrentContext().evaluateString((Scriptable)this.moduleScope, IOUtils.toString((InputStream)script), file, 1, null);
            }
            finally {
                IOUtils.closeQuietly((InputStream)script);
            }
        }
        catch (IOException e) {
            throw new SmallerException("Failed to include script file", (Throwable)e);
        }
    }

    public void addScriptFile(URL url) {
        try {
            Context.getCurrentContext().evaluateString((Scriptable)this.moduleScope, IOUtils.toString((URL)url), url.getFile(), 1, null);
        }
        catch (IOException e) {
            throw new SmallerException("Failed to include script file", (Throwable)e);
        }
    }

    public void addCallScript(String source) {
        this.source = source;
    }

    public void run(Reader input, Writer output) throws IOException {
        if (this.initializing && Context.getCurrentContext() != null) {
            this.initializing = false;
            Context.exit();
        }
        String data = new ObjectMapper().writeValueAsString((Object)IOUtils.toString((Reader)input));
        Context context = Context.enter();
        try {
            try {
                ScriptableObject scope = (ScriptableObject)context.initStandardObjects((ScriptableObject)this.moduleScope);
                Object result = context.evaluateString((Scriptable)scope, String.format(this.source, data), this.name, 1, null);
                output.append(String.valueOf(result));
            }
            catch (JavaScriptException e) {
                throw new SmallerException("Failed to run javascript", (Throwable)e);
            }
        }
        finally {
            Context.exit();
        }
    }

    private ModuleScriptProvider getModuleScriptProvider(final Class<?> clazz) {
        return new ModuleScriptProvider(){

            public ModuleScript getModuleScript(Context cx, String moduleId, URI moduleUri, URI baseUri, Scriptable paths) throws IOException, URISyntaxException {
                return JavaScriptExecutor.this.getModuleScript(cx, moduleId, clazz);
            }
        };
    }

    private ModuleScript getModuleScript(Context cx, String moduleId, Class<?> clazz) throws IOException, URISyntaxException {
        String path = String.valueOf('/') + this.name + '/' + moduleId + ".js";
        URL url = clazz.getResource(path);
        if (url == null) {
            return null;
        }
        return new ModuleScript(cx.compileString(IOUtils.toString((URL)url), moduleId, 1, null), new URI(moduleId), null);
    }
}

