/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.genetic.intguessing;

import de.sfuhrm.genetic.GeneticAlgorithm;
import de.sfuhrm.genetic.intguessing.IntGuessingHypothesis;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Supplier;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public final class GuessingExample {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";
    @Option(name="-h", usage="help", aliases={"-help"}, help=true)
    private boolean help;
    private static final double CROSS_OVER_RATE_DEFAULT = 0.5;
    @Option(name="-x", usage="cross over rate (0..1)", metaVar="RATE", aliases={"-crossover"})
    private double crossOverRate = 0.5;
    private static final double MUTATION_RATE_DEFAULT = 0.02;
    @Option(name="-m", usage="mutation rate (0..1)", metaVar="RATE", aliases={"-mutation"})
    private double mutationRate = 0.02;
    private static final int GENERATION_SIZE_DEFAULT = 150;
    @Option(name="-p", usage="the size of the population/generation in individuals (0..n)", metaVar="INDIVIDUALS", aliases={"-population"})
    private int generationSize = 150;
    private static final int ARRAY_SIZE_DEFAULT = 9;
    @Option(name="-s", usage="the size of the array to guess the elements of", metaVar="SIZE", aliases={"-genome"})
    private int arraySize = 9;
    @Option(name="-t", usage="the number of CPU threads to use for parallel calculation", metaVar="COUNT", aliases={"-threads"})
    private int threadCount = Runtime.getRuntime().availableProcessors();
    private static long generation;
    private static int[] oldGenome;
    private static final double MILLIS_PER_SECOND = 1000.0;

    private GuessingExample() {
    }

    private static GuessingExample parse(String[] args) {
        GuessingExample result = new GuessingExample();
        CmdLineParser parser = new CmdLineParser((Object)result);
        try {
            parser.parseArgument(args);
            if (result.help) {
                parser.printUsage((OutputStream)System.err);
                return null;
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            return null;
        }
        return result;
    }

    private static void print(IntGuessingHypothesis h) {
        System.out.printf("%03d: ", ++generation);
        for (int i = 0; i < h.getGenome().length; ++i) {
            int currentCellValue = h.getGenome()[i];
            int previousCellValue = -1;
            if (oldGenome != null) {
                previousCellValue = oldGenome[i];
            }
            GuessingExample.printCell(i, currentCellValue, previousCellValue);
        }
        System.out.println();
        oldGenome = Arrays.copyOf(h.getGenome(), h.getGenome().length);
    }

    private static void printCell(int index, int currentCellValue, int previousCellValue) {
        String color = ANSI_WHITE;
        if (currentCellValue == index && currentCellValue == previousCellValue) {
            color = ANSI_GREEN;
        }
        if (currentCellValue == index && currentCellValue != previousCellValue) {
            color = ANSI_CYAN;
        }
        if (currentCellValue != index) {
            color = ANSI_RED;
        }
        System.out.printf("%s[%d]%s", color, currentCellValue, ANSI_RESET);
    }

    public static void main(String[] args) {
        GuessingExample guessingExample = GuessingExample.parse(args);
        if (guessingExample == null) {
            return;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(guessingExample.threadCount);
        GeneticAlgorithm algorithm = new GeneticAlgorithm(guessingExample.getCrossOverRate(), guessingExample.getMutationRate(), guessingExample.getGenerationSize());
        int size = guessingExample.getArraySize();
        long start = System.currentTimeMillis();
        Function<IntGuessingHypothesis, Boolean> loopFunction = h -> {
            GuessingExample.print(h);
            return h.calculateFitness() < h.maximumFitness();
        };
        Supplier<IntGuessingHypothesis> hypothesisSupplier = () -> new IntGuessingHypothesis(size);
        Optional max = guessingExample.threadCount == 1 ? algorithm.findMaximum(loopFunction, hypothesisSupplier) : algorithm.findMaximum(loopFunction, hypothesisSupplier, executorService);
        System.out.println();
        double duration = (double)(System.currentTimeMillis() - start) / 1000.0;
        executorService.shutdown();
        System.out.printf("Maximum is %s with fitness=%.2f, speed=%.2f gen/s%n", max, ((IntGuessingHypothesis)((Object)max.get())).calculateFitness(), (double)generation / duration);
    }

    public double getCrossOverRate() {
        return this.crossOverRate;
    }

    public double getMutationRate() {
        return this.mutationRate;
    }

    public int getGenerationSize() {
        return this.generationSize;
    }

    public int getArraySize() {
        return this.arraySize;
    }

    public int getThreadCount() {
        return this.threadCount;
    }
}

