/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.genetic.intguessing;

import de.sfuhrm.genetic.AbstractHypothesis;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;

public final class IntGuessingHypothesis
extends AbstractHypothesis<IntGuessingHypothesis> {
    private int[] genome;

    public IntGuessingHypothesis(int totalNumbers) {
        this.genome = new int[totalNumbers];
    }

    protected IntGuessingHypothesis randomInit() {
        IntStream.range(0, this.genome.length).forEach(i -> {
            this.genome[i] = IntGuessingHypothesis.getRANDOM().nextInt(this.genome.length);
        });
        return this;
    }

    protected List<IntGuessingHypothesis> crossOver(IntGuessingHypothesis other) {
        int point = IntGuessingHypothesis.getRANDOM().nextInt(this.genome.length);
        IntGuessingHypothesis one = new IntGuessingHypothesis(this.genome.length);
        IntGuessingHypothesis two = new IntGuessingHypothesis(this.genome.length);
        for (int i = 0; i < this.genome.length; ++i) {
            one.genome[i] = i < point ? this.genome[i] : other.genome[i];
            two.genome[i] = i >= point ? this.genome[i] : other.genome[i];
        }
        return Arrays.asList(one, two);
    }

    protected double maximumFitness() {
        return Math.exp(this.genome.length);
    }

    protected double calculateFitness() {
        double fitness = 0.0;
        for (int i = 0; i < this.genome.length; ++i) {
            int genomeValue = this.genome[i];
            if (genomeValue == i) {
                fitness += 1.0;
                continue;
            }
            fitness -= (double)Math.abs(genomeValue - i);
        }
        return Math.exp(fitness);
    }

    protected void mutate() {
        int point = IntGuessingHypothesis.getRANDOM().nextInt(this.genome.length);
        this.genome[point] = IntGuessingHypothesis.getRANDOM().nextInt(this.genome.length);
    }

    public String toString() {
        return Arrays.toString(this.genome);
    }

    public int[] getGenome() {
        return this.genome;
    }

    protected void setGenome(int[] genome) {
        this.genome = genome;
    }
}

