/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.simplehttpserver;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import dev.katsute.simplehttpserver.HttpSession;
import java.net.HttpCookie;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class HttpSessionHandler {
    private final Map<String, HttpSession> sessions = Collections.synchronizedMap(new HashMap());
    private final String cookie;

    public HttpSessionHandler() {
        this("__session-id");
    }

    public HttpSessionHandler(String cookie) {
        this.cookie = Objects.requireNonNull(cookie);
    }

    public synchronized String assignSessionID(HttpExchange exchange) {
        String id;
        while (this.sessions.containsKey(id = UUID.randomUUID().toString())) {
        }
        return id;
    }

    private String getSetSession(Headers headers) {
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase("Set-Cookie")) continue;
            for (String value : entry.getValue()) {
                if (!value.startsWith(this.cookie + "=\"")) continue;
                return value.substring(this.cookie.length() + 2, value.length() - 1);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HttpSession getSession(final HttpExchange exchange) {
        HttpSession session;
        String setSession;
        HashMap<String, String> cookies = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : Objects.requireNonNull(exchange).getRequestHeaders().entrySet()) {
            if (!entry.getKey().equalsIgnoreCase("Cookie")) continue;
            for (String value : entry.getValue()) {
                String[] pair = value.split("=");
                cookies.put(pair[0], pair[1]);
            }
        }
        String sessionID = (setSession = this.getSetSession(exchange.getResponseHeaders())) != null ? setSession : (String)cookies.get(this.cookie);
        HttpSessionHandler httpSessionHandler = this;
        synchronized (httpSessionHandler) {
            if (!this.sessions.containsKey(sessionID)) {
                session = new HttpSession(){
                    private final String sessionID;
                    private final long creationTime;
                    private long lastAccessTime;
                    {
                        this.sessionID = HttpSessionHandler.this.assignSessionID(exchange);
                        this.lastAccessTime = this.creationTime = System.currentTimeMillis();
                        HttpSessionHandler.this.sessions.put(this.sessionID, this);
                    }

                    @Override
                    public final String getSessionID() {
                        return this.sessionID;
                    }

                    @Override
                    public final long getCreationTime() {
                        return this.creationTime;
                    }

                    @Override
                    public final long getLastAccessed() {
                        return this.lastAccessTime;
                    }

                    @Override
                    public final synchronized void update() {
                        this.lastAccessTime = System.currentTimeMillis();
                    }
                };
                HttpCookie OUT = new HttpCookie(this.cookie, session.getSessionID());
                OUT.setHttpOnly(true);
                exchange.getResponseHeaders().add("Set-Cookie", OUT.toString());
                this.sessions.put(session.getSessionID(), session);
            } else {
                session = this.sessions.get(sessionID);
            }
        }
        return session;
    }

    public String toString() {
        return "HttpSessionHandler{sessions=" + this.sessions + ", cookie='" + this.cookie + '\'' + '}';
    }
}

