/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.bytecodebuilder;

import dev.lukebemish.bytecodebuilder.ClassContext;
import dev.lukebemish.bytecodebuilder.ClassSignature;
import dev.lukebemish.bytecodebuilder.CodeContext;
import dev.lukebemish.bytecodebuilder.FieldContext;
import dev.lukebemish.bytecodebuilder.MethodContext;
import dev.lukebemish.bytecodebuilder.MethodSignature;
import dev.lukebemish.bytecodebuilder.Signature;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class BackendASM {
    private BackendASM() {
    }

    public static ClassContextASM createClass(Consumer<? super ClassContextASM> consumer) {
        ClassContextASM classContext = new ClassContextASM();
        consumer.accept(classContext);
        return classContext;
    }

    public static ClassContextASM createClass() {
        return new ClassContextASM();
    }

    public static FieldContextASM createField(Consumer<? super FieldContextASM> consumer) {
        FieldContextASM fieldContext = new FieldContextASM();
        consumer.accept(fieldContext);
        return fieldContext;
    }

    public static FieldContextASM createField() {
        return new FieldContextASM();
    }

    public static MethodContextASM createMethod(Consumer<? super MethodContextASM> consumer) {
        MethodContextASM methodContext = new MethodContextASM();
        consumer.accept(methodContext);
        return methodContext;
    }

    public static MethodContextASM createMethod() {
        return new MethodContextASM();
    }

    public static CodeContextASM createCode(Consumer<? super CodeContextASM> consumer) {
        CodeContextASM codeContext = new CodeContextASM();
        consumer.accept(codeContext);
        return codeContext;
    }

    public static CodeContextASM createCode() {
        return new CodeContextASM();
    }

    public static final class ClassContextASM
    extends ClassContext<ClassContextASM, FieldContextASM, MethodContextASM> {
        private final List<Consumer<ClassVisitor>> classVisitors = new ArrayList<Consumer<ClassVisitor>>();

        private ClassContextASM() {
        }

        public ClassContextASM asm(Consumer<ClassVisitor> consumer) {
            this.classVisitors.add(consumer);
            return this;
        }

        public ClassContextASM constructor(int access, MethodTypeDesc descriptor, @Nullable Collection<ClassDesc> exceptions, Consumer<? super MethodContextASM> remainder) {
            return this.method("<init>", access, descriptor, (MethodSignature)null, (Collection)exceptions, (Consumer)remainder);
        }

        public ClassContextASM method(String name, int access, MethodTypeDesc descriptor, @Nullable MethodSignature signature, @Nullable Collection<ClassDesc> exceptions, Consumer<? super MethodContextASM> remainder) {
            String[] exceptionsNames = new String[exceptions == null ? 0 : exceptions.size()];
            if (exceptions != null) {
                int i = 0;
                for (ClassDesc exception : exceptions) {
                    exceptionsNames[i++] = ConstantsASM.toAsm(exception).getInternalName();
                }
            }
            MethodContextASM methodContext = BackendASM.createMethod(remainder);
            this.classVisitors.add(cv -> {
                MethodVisitor mv = cv.visitMethod(access, name, descriptor.descriptorString(), signature == null ? null : signature.signature(), exceptionsNames);
                methodContext.apply(mv);
                mv.visitEnd();
            });
            return this;
        }

        public ClassContextASM field(String name, int access, ClassDesc descriptor, @Nullable Signature signature, @Nullable ConstantDesc constant, Consumer<? super FieldContextASM> remainder) {
            Object constValue;
            if (constant != null) {
                if ((access & 8) == 0 || (access & 0x10) == 0) {
                    throw new IllegalArgumentException("Constant value can only be set for static final fields");
                }
                Object object = constValue = ConstantsASM.toAsm(constant);
                Objects.requireNonNull(object);
                Object object2 = object;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, Float.class, Double.class, String.class}, (Object)object2, n)) {
                    case 0: {
                        Integer ignored = (Integer)object2;
                        break;
                    }
                    case 1: {
                        Long ignored = (Long)object2;
                        break;
                    }
                    case 2: {
                        Float ignored = (Float)object2;
                        break;
                    }
                    case 3: {
                        Double ignored = (Double)object2;
                        break;
                    }
                    case 4: {
                        String ignored = (String)object2;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Constant value must be a primitive or string for a field initializer, but was " + String.valueOf(constValue));
                    }
                }
            } else {
                constValue = null;
            }
            FieldContextASM fieldContext = BackendASM.createField(remainder);
            this.classVisitors.add(cv -> {
                FieldVisitor fv = cv.visitField(access, name, descriptor.descriptorString(), signature == null ? null : signature.signature(), constValue);
                fieldContext.apply(fv);
                fv.visitEnd();
            });
            return this;
        }

        public void apply(ClassVisitor classVisitor) {
            for (Consumer<ClassVisitor> consumer : this.classVisitors) {
                consumer.accept(classVisitor);
            }
        }

        @Override
        public byte[] build(int version, int access, ClassDesc name, ClassDesc superName, @Nullable Collection<ClassDesc> interfaces, @Nullable ClassSignature signature) {
            ClassWriter cv = new ClassWriter(3);
            cv.visit(version, access, ConstantsASM.toAsm(name).getInternalName(), signature == null ? null : signature.signature(), ConstantsASM.toAsm(superName).getInternalName(), interfaces == null ? null : (String[])interfaces.stream().map(ConstantsASM::toAsm).map(Type::getInternalName).toArray(String[]::new));
            this.apply((ClassVisitor)cv);
            cv.visitEnd();
            return cv.toByteArray();
        }
    }

    public static final class FieldContextASM
    extends FieldContext<FieldContextASM> {
        private final List<Consumer<FieldVisitor>> classVisitors = new ArrayList<Consumer<FieldVisitor>>();

        private FieldContextASM() {
        }

        public FieldContextASM asm(Consumer<FieldVisitor> consumer) {
            this.classVisitors.add(consumer);
            return this;
        }

        public void apply(FieldVisitor fieldVisitor) {
            for (Consumer<FieldVisitor> consumer : this.classVisitors) {
                consumer.accept(fieldVisitor);
            }
        }
    }

    public static final class MethodContextASM
    extends MethodContext<MethodContextASM, CodeContextASM> {
        private final List<Consumer<MethodVisitor>> methodVisitors = new ArrayList<Consumer<MethodVisitor>>();

        private MethodContextASM() {
        }

        public MethodContextASM asm(Consumer<MethodVisitor> consumer) {
            this.methodVisitors.add(consumer);
            return this;
        }

        public MethodContextASM code(Consumer<? super CodeContextASM> consumer, int maxStack, int maxLocal) {
            CodeContextASM codeContext = BackendASM.createCode(consumer);
            this.methodVisitors.add(mv -> {
                mv.visitCode();
                codeContext.apply((MethodVisitor)mv);
                mv.visitMaxs(maxStack, maxLocal);
            });
            return this;
        }

        public MethodContextASM code(Consumer<? super CodeContextASM> consumer) {
            return this.code(consumer, 0, 0);
        }

        public void apply(MethodVisitor methodVisitor) {
            for (Consumer<MethodVisitor> consumer : this.methodVisitors) {
                consumer.accept(methodVisitor);
            }
        }
    }

    public static final class CodeContextASM
    extends CodeContext<CodeContextASM> {
        private final List<Consumer<MethodVisitor>> codeVisitors = new ArrayList<Consumer<MethodVisitor>>();

        private CodeContextASM() {
        }

        public CodeContextASM asm(Consumer<MethodVisitor> consumer) {
            this.codeVisitors.add(consumer);
            return this;
        }

        public CodeContextASM instruction(int opcode) {
            this.codeVisitors.add(mv -> mv.visitInsn(opcode));
            return this;
        }

        public CodeContextASM constant(ConstantDesc constant) {
            this.codeVisitors.add(mv -> {
                ConstantDesc constantDesc = constant;
                Objects.requireNonNull(constantDesc);
                ConstantDesc selector0$temp = constantDesc;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, Float.class, Double.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        Integer i = (Integer)selector0$temp;
                        int iInt = i;
                        if (iInt == -1) {
                            mv.visitInsn(2);
                            break;
                        }
                        if (0 <= iInt && iInt <= 5) {
                            mv.visitInsn(3 + iInt);
                            break;
                        }
                        if (iInt >= -128 && iInt <= 127) {
                            mv.visitIntInsn(16, iInt);
                            break;
                        }
                        if (iInt >= Short.MIN_VALUE && iInt <= Short.MAX_VALUE) {
                            mv.visitIntInsn(17, iInt);
                            break;
                        }
                        mv.visitLdcInsn((Object)i);
                        break;
                    }
                    case 1: {
                        Long l = (Long)selector0$temp;
                        long lLong = l;
                        if (lLong == 0L) {
                            mv.visitInsn(9);
                            break;
                        }
                        if (lLong == 1L) {
                            mv.visitInsn(10);
                            break;
                        }
                        mv.visitLdcInsn((Object)l);
                        break;
                    }
                    case 2: {
                        Float f = (Float)selector0$temp;
                        float fFloat = f.floatValue();
                        if (fFloat == 0.0f) {
                            mv.visitInsn(11);
                            break;
                        }
                        if (fFloat == 1.0f) {
                            mv.visitInsn(12);
                            break;
                        }
                        if (fFloat == 2.0f) {
                            mv.visitInsn(13);
                            break;
                        }
                        mv.visitLdcInsn((Object)f);
                        break;
                    }
                    case 3: {
                        Double d = (Double)selector0$temp;
                        double dDouble = d;
                        if (dDouble == 0.0) {
                            mv.visitInsn(14);
                            break;
                        }
                        if (dDouble == 1.0) {
                            mv.visitInsn(15);
                            break;
                        }
                        mv.visitLdcInsn((Object)d);
                        break;
                    }
                    default: {
                        mv.visitLdcInsn(ConstantsASM.toAsm(constant));
                    }
                }
            });
            return this;
        }

        public CodeContextASM load(ClassDesc descriptor, int index) {
            this.codeVisitors.add(mv -> mv.visitVarInsn(ConstantsASM.toAsm(descriptor).getOpcode(21), index));
            return this;
        }

        public CodeContextASM store(ClassDesc descriptor, int index) {
            this.codeVisitors.add(mv -> mv.visitVarInsn(ConstantsASM.toAsm(descriptor).getOpcode(54), index));
            return this;
        }

        public CodeContextASM newArray(ClassDesc descriptor) {
            this.codeVisitors.add(mv -> {
                if (ConstantsASM.toAsm(descriptor).getSort() <= 8) {
                    mv.visitIntInsn(188, 4 + ConstantsASM.toAsm(descriptor).getSort() - 1);
                } else {
                    mv.visitTypeInsn(189, ConstantsASM.toAsm(descriptor).getInternalName());
                }
            });
            return this;
        }

        public CodeContextASM instanceOf(ClassDesc descriptor) {
            this.codeVisitors.add(mv -> mv.visitTypeInsn(193, ConstantsASM.toAsm(descriptor).getInternalName()));
            return this;
        }

        public CodeContextASM checkCast(ClassDesc descriptor) {
            this.codeVisitors.add(mv -> mv.visitTypeInsn(192, ConstantsASM.toAsm(descriptor).getInternalName()));
            return this;
        }

        public CodeContextASM returnValue(ClassDesc descriptor) {
            if (descriptor.descriptorString().equals("V")) {
                this.codeVisitors.add(mv -> mv.visitInsn(177));
                return this;
            }
            this.codeVisitors.add(mv -> mv.visitInsn(ConstantsASM.toAsm(descriptor).getOpcode(172)));
            return this;
        }

        public CodeContextASM field(DirectMethodHandleDesc.Kind operation, ClassDesc owner, String name, ClassDesc descriptor) {
            this.codeVisitors.add(mv -> mv.visitFieldInsn(switch (operation) {
                case DirectMethodHandleDesc.Kind.STATIC_GETTER -> 178;
                case DirectMethodHandleDesc.Kind.STATIC_SETTER -> 179;
                case DirectMethodHandleDesc.Kind.GETTER -> 180;
                case DirectMethodHandleDesc.Kind.SETTER -> 181;
                default -> throw new IllegalArgumentException("Invalid field operation: " + String.valueOf((Object)operation));
            }, ConstantsASM.toAsm(owner).getInternalName(), name, descriptor.descriptorString()));
            return this;
        }

        public CodeContextASM method(DirectMethodHandleDesc.Kind operation, ClassDesc owner, String name, MethodTypeDesc descriptor) {
            if (operation == DirectMethodHandleDesc.Kind.CONSTRUCTOR) {
                if (!"<init>".equals(name)) {
                    throw new IllegalArgumentException("CONSTRUCTOR must be used with <init> method");
                }
                return this.newInstance(owner, descriptor);
            }
            this.codeVisitors.add(mv -> mv.visitMethodInsn(switch (operation) {
                case DirectMethodHandleDesc.Kind.STATIC, DirectMethodHandleDesc.Kind.INTERFACE_STATIC -> 184;
                case DirectMethodHandleDesc.Kind.VIRTUAL -> 182;
                case DirectMethodHandleDesc.Kind.INTERFACE_VIRTUAL -> 185;
                case DirectMethodHandleDesc.Kind.SPECIAL, DirectMethodHandleDesc.Kind.INTERFACE_SPECIAL -> 183;
                default -> throw new IllegalArgumentException("Invalid method operation: " + String.valueOf((Object)operation));
            }, ConstantsASM.toAsm(owner).getInternalName(), name, descriptor.descriptorString(), operation.isInterface));
            return this;
        }

        public CodeContextASM newInstance(ClassDesc owner, MethodTypeDesc constructorDescriptor) {
            this.codeVisitors.add(mv -> {
                mv.visitTypeInsn(187, ConstantsASM.toAsm(owner).getInternalName());
                mv.visitInsn(89);
                mv.visitMethodInsn(183, ConstantsASM.toAsm(owner).getInternalName(), "<init>", constructorDescriptor.descriptorString(), false);
            });
            return this;
        }

        public CodeContextASM invokeDynamic(String name, MethodTypeDesc descriptor, DirectMethodHandleDesc bootstrap, Collection<ConstantDesc> bootstrapArguments) {
            this.codeVisitors.add(mv -> mv.visitInvokeDynamicInsn(name, descriptor.descriptorString(), ConstantsASM.toAsm(bootstrap), bootstrapArguments.stream().map(ConstantsASM::toAsm).toArray()));
            return this;
        }

        public CodeContextASM jump(int instruction, Consumer<? super CodeContextASM> skip) {
            this.codeVisitors.add(mv -> {
                Label label = new Label();
                mv.visitJumpInsn(instruction, label);
                CodeContextASM skipContext = new CodeContextASM();
                skip.accept(skipContext);
                skipContext.apply((MethodVisitor)mv);
                mv.visitLabel(label);
            });
            return this;
        }

        public CodeContextASM loadThis() {
            this.codeVisitors.add(mv -> mv.visitVarInsn(25, 0));
            return this;
        }

        public void apply(MethodVisitor methodVisitor) {
            for (Consumer<MethodVisitor> consumer : this.codeVisitors) {
                consumer.accept(methodVisitor);
            }
        }
    }

    public static final class ConstantsASM {
        private ConstantsASM() {
        }

        public static ConstantDesc from(Type type) {
            if (type.getSort() == 11) {
                return MethodTypeDesc.ofDescriptor(type.getDescriptor());
            }
            return ConstantsASM.fromClass(type);
        }

        public static ClassDesc fromClass(Type type) {
            if (type.getSort() == 11) {
                throw new IllegalArgumentException("Method types cannot be converted to ClassDesc");
            }
            return ClassDesc.ofDescriptor(type.getDescriptor());
        }

        public static DirectMethodHandleDesc from(Handle handle) {
            return MethodHandleDesc.of(DirectMethodHandleDesc.Kind.valueOf(handle.getTag(), handle.isInterface()), ConstantsASM.fromClass(Type.getObjectType((String)handle.getOwner())), handle.getName(), handle.getDesc());
        }

        public static DynamicConstantDesc<?> from(ConstantDynamic constantDynamic) {
            ConstantDesc[] args = new ConstantDesc[constantDynamic.getBootstrapMethodArgumentCount()];
            for (int i = 0; i < args.length; ++i) {
                Object object;
                Object arg = constantDynamic.getBootstrapMethodArgument(i);
                Objects.requireNonNull(arg);
                int n = 0;
                args[i] = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Type.class, Handle.class, ConstantDynamic.class, ConstantDesc.class}, (Object)object, n)) {
                    case 0 -> {
                        Type type = (Type)object;
                        yield ConstantsASM.from(type);
                    }
                    case 1 -> {
                        Handle handle = (Handle)object;
                        yield ConstantsASM.from(handle);
                    }
                    case 2 -> {
                        ConstantDynamic nested = (ConstantDynamic)object;
                        yield ConstantsASM.from(nested);
                    }
                    case 3 -> {
                        DynamicConstantDesc<?> desc;
                        yield desc = (DynamicConstantDesc<?>)object;
                    }
                    default -> throw new IllegalArgumentException("Unexpected bootstrap method argument type: " + String.valueOf(arg.getClass()));
                };
            }
            return DynamicConstantDesc.ofNamed(ConstantsASM.from(constantDynamic.getBootstrapMethod()), constantDynamic.getName(), ConstantsASM.fromClass(Type.getType((String)constantDynamic.getDescriptor())), args);
        }

        public static Type toAsm(ClassDesc classDesc) {
            return Type.getType((String)classDesc.descriptorString());
        }

        public static Type toAsm(MethodTypeDesc methodTypeDesc) {
            return Type.getMethodType((String)methodTypeDesc.descriptorString());
        }

        public static Handle toAsm(DirectMethodHandleDesc methodHandleDesc) {
            return new Handle(methodHandleDesc.kind().refKind, Type.getType((String)methodHandleDesc.owner().descriptorString()).getInternalName(), methodHandleDesc.methodName(), methodHandleDesc.lookupDescriptor(), methodHandleDesc.kind().isInterface);
        }

        public static ConstantDynamic toAsm(DynamicConstantDesc<?> dynamicConstantDesc) {
            Object[] args = dynamicConstantDesc.bootstrapArgsList().stream().map(ConstantsASM::toAsm).toArray(Object[]::new);
            return new ConstantDynamic(dynamicConstantDesc.constantName(), dynamicConstantDesc.constantType().descriptorString(), ConstantsASM.toAsm(dynamicConstantDesc.bootstrapMethod()), args);
        }

        public static Object toAsm(ConstantDesc constantDesc) {
            ConstantDesc constantDesc2 = constantDesc;
            Objects.requireNonNull(constantDesc2);
            ConstantDesc constantDesc3 = constantDesc2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DynamicConstantDesc.class, MethodTypeDesc.class, DirectMethodHandleDesc.class, ClassDesc.class}, (Object)constantDesc3, n)) {
                case 0 -> {
                    DynamicConstantDesc dynamicConstantDesc = (DynamicConstantDesc)constantDesc3;
                    yield ConstantsASM.toAsm(dynamicConstantDesc);
                }
                case 1 -> {
                    MethodTypeDesc methodTypeDesc = (MethodTypeDesc)constantDesc3;
                    yield ConstantsASM.toAsm(methodTypeDesc);
                }
                case 2 -> {
                    DirectMethodHandleDesc methodHandleDesc = (DirectMethodHandleDesc)constantDesc3;
                    yield ConstantsASM.toAsm(methodHandleDesc);
                }
                case 3 -> {
                    ClassDesc classDesc = (ClassDesc)constantDesc3;
                    yield ConstantsASM.toAsm(classDesc);
                }
                default -> constantDesc;
            };
        }
    }
}

