/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.bytecodebuilder;

import dev.lukebemish.bytecodebuilder.Signature;
import java.util.Collection;

public final class MethodSignature {
    private final String signature;

    private MethodSignature(String signature) {
        this.signature = signature;
    }

    public String signature() {
        return this.signature;
    }

    public Builder create() {
        return new Builder();
    }

    public static final class Builder {
        private final StringBuilder signature = new StringBuilder();

        public Builder typeParameter(String name, Signature classBound, Signature ... interfaceBounds) {
            this.signature.append(name);
            this.signature.append(':').append(classBound.signature());
            for (Signature interfaceBound : interfaceBounds) {
                this.signature.append(':').append(interfaceBound.signature());
            }
            return this;
        }

        public MethodSignature build(Signature returnType, Signature ... parameters) {
            StringBuilder full = new StringBuilder();
            if (!this.signature.isEmpty()) {
                full.append('<').append((CharSequence)this.signature).append('>');
            }
            full.append('(');
            for (Signature parameter : parameters) {
                full.append(parameter.signature());
            }
            full.append(')');
            full.append(returnType.signature());
            return new MethodSignature(full.toString());
        }

        public MethodSignature build(Signature returnType, Collection<Signature> throwsSignatures, Signature ... parameters) {
            StringBuilder full = new StringBuilder();
            if (!this.signature.isEmpty()) {
                full.append('<').append((CharSequence)this.signature).append('>');
            }
            full.append('(');
            for (Signature parameter : parameters) {
                full.append(parameter.signature());
            }
            full.append(')');
            full.append(returnType.signature());
            for (Signature throwsSignature : throwsSignatures) {
                full.append('^').append(throwsSignature.signature());
            }
            return new MethodSignature(full.toString());
        }
    }
}

