/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.simpleapi;

import lombok.NonNull;

public class RequestHeader {
    private final String key;
    private final String value;

    private RequestHeader(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @NonNull
    public static RequestHeader of(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new RequestHeader(key, value);
    }

    @NonNull
    public static RequestHeader ofContentType(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new RequestHeader("Content-Type", value);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }
}

