/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.simpleapi;

import dev.mayuna.simpleapi.ApiRequest;
import dev.mayuna.simpleapi.PathParameter;
import dev.mayuna.simpleapi.RequestHeader;
import dev.mayuna.simpleapi.RequestMethod;
import dev.mayuna.simpleapi.RequestQuery;
import dev.mayuna.simpleapi.WrappedApi;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApiRequestBuilder<T> {
    private final WrappedApi wrappedApi;
    private final Class<T> responseClass;
    private String url;
    private String endpoint;
    private RequestMethod requestMethod;
    private List<PathParameter> pathParameters = new ArrayList<PathParameter>();
    private List<RequestQuery> requestQueries = new ArrayList<RequestQuery>();
    private List<RequestHeader> requestHeaders = new ArrayList<RequestHeader>();
    private HttpRequest.BodyPublisher bodyPublisher;
    private HttpResponse.BodyHandler<?> bodyHandler;

    private ApiRequestBuilder(WrappedApi wrappedApi, Class<T> responseClass) {
        this.wrappedApi = wrappedApi;
        this.responseClass = responseClass;
    }

    public static <T> ApiRequestBuilder<T> ofResponse(WrappedApi wrappedApi, Class<T> responseClass) {
        return new ApiRequestBuilder<T>(wrappedApi, responseClass);
    }

    public ApiRequestBuilder<T> withUrl(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        this.url = url;
        return this;
    }

    public ApiRequestBuilder<T> withEndpoint(@NonNull String endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (!((String)endpoint).startsWith("/")) {
            endpoint = "/" + (String)endpoint;
        }
        this.endpoint = endpoint;
        return this;
    }

    public ApiRequestBuilder<T> withRequestMethod(@NonNull RequestMethod requestMethod) {
        if (requestMethod == null) {
            throw new NullPointerException("requestMethod is marked non-null but is null");
        }
        this.requestMethod = requestMethod;
        return this;
    }

    public ApiRequestBuilder<T> withRequestMethod(@NonNull String requestMethod) {
        if (requestMethod == null) {
            throw new NullPointerException("requestMethod is marked non-null but is null");
        }
        this.requestMethod = RequestMethod.of(requestMethod);
        return this;
    }

    public ApiRequestBuilder<T> withPathParameter(@NonNull PathParameter pathParameter) {
        if (pathParameter == null) {
            throw new NullPointerException("pathParameter is marked non-null but is null");
        }
        this.pathParameters.add(pathParameter);
        return this;
    }

    public ApiRequestBuilder<T> withPathParameters(@NonNull PathParameter pathParameter, PathParameter ... pathParameters) {
        if (pathParameter == null) {
            throw new NullPointerException("pathParameter is marked non-null but is null");
        }
        this.withPathParameter(pathParameter);
        if (pathParameters != null) {
            for (PathParameter anotherPathParameter : pathParameters) {
                this.withPathParameter(anotherPathParameter);
            }
        }
        return this;
    }

    public ApiRequestBuilder<T> withRequestQuery(@NonNull RequestQuery requestQuery) {
        if (requestQuery == null) {
            throw new NullPointerException("requestQuery is marked non-null but is null");
        }
        this.requestQueries.add(requestQuery);
        return this;
    }

    public ApiRequestBuilder<T> withRequestQueries(@NonNull RequestQuery requestQuery, RequestQuery ... requestQueries) {
        if (requestQuery == null) {
            throw new NullPointerException("requestQuery is marked non-null but is null");
        }
        this.withRequestQuery(requestQuery);
        if (requestQueries != null) {
            for (RequestQuery anotherRequestQuery : requestQueries) {
                this.withRequestQuery(anotherRequestQuery);
            }
        }
        return this;
    }

    public ApiRequestBuilder<T> withRequestHeader(@NonNull RequestHeader requestHeader) {
        if (requestHeader == null) {
            throw new NullPointerException("requestHeader is marked non-null but is null");
        }
        this.requestHeaders.add(requestHeader);
        return this;
    }

    public ApiRequestBuilder<T> withRequestHeaders(@NonNull RequestHeader requestHeader, RequestHeader ... requestHeaders) {
        if (requestHeader == null) {
            throw new NullPointerException("requestHeader is marked non-null but is null");
        }
        this.withRequestHeader(requestHeader);
        if (requestHeaders != null) {
            for (RequestHeader anotherRequestHeader : requestHeaders) {
                this.withRequestHeader(anotherRequestHeader);
            }
        }
        return this;
    }

    public ApiRequestBuilder<T> withBodyPublisher(@NonNull HttpRequest.BodyPublisher bodyPublisher) {
        if (bodyPublisher == null) {
            throw new NullPointerException("bodyPublisher is marked non-null but is null");
        }
        this.bodyPublisher = bodyPublisher;
        return this;
    }

    public ApiRequestBuilder<T> withBodyHandler(@NonNull HttpResponse.BodyHandler<?> bodyHandler) {
        if (bodyHandler == null) {
            throw new NullPointerException("bodyHandler is marked non-null but is null");
        }
        this.bodyHandler = bodyHandler;
        return this;
    }

    public ApiRequest<T> build() {
        return new ApiRequest<T>(){

            @Override
            @NotNull
            public Class<T> getResponseClass() {
                return ApiRequestBuilder.this.responseClass;
            }

            @Override
            @NotNull
            public WrappedApi getWrappedApi() {
                return ApiRequestBuilder.this.wrappedApi;
            }

            @Override
            @NotNull
            public String getUrl() {
                return ApiRequestBuilder.this.url;
            }

            @Override
            @NotNull
            public String getEndpoint() {
                return ApiRequestBuilder.this.endpoint;
            }

            @Override
            @NotNull
            public RequestMethod getRequestMethod() {
                return ApiRequestBuilder.this.requestMethod;
            }

            @Override
            @Nullable
            public PathParameter[] getPathParameters() {
                if (ApiRequestBuilder.this.pathParameters.isEmpty()) {
                    return null;
                }
                return ApiRequestBuilder.this.pathParameters.toArray(new PathParameter[0]);
            }

            @Override
            @Nullable
            public RequestQuery[] getRequestQueries() {
                if (ApiRequestBuilder.this.requestQueries.isEmpty()) {
                    return null;
                }
                return ApiRequestBuilder.this.requestQueries.toArray(new RequestQuery[0]);
            }

            @Override
            @Nullable
            public RequestHeader[] getRequestHeaders() {
                if (ApiRequestBuilder.this.requestHeaders.isEmpty()) {
                    return null;
                }
                return ApiRequestBuilder.this.requestHeaders.toArray(new RequestHeader[0]);
            }

            @Override
            @NonNull
            public HttpRequest.BodyPublisher getBodyPublisher() {
                return Objects.requireNonNullElseGet(ApiRequestBuilder.this.bodyPublisher, () -> ApiRequest.super.getBodyPublisher());
            }

            @Override
            @NonNull
            public HttpResponse.BodyHandler<?> getBodyHandler() {
                return Objects.requireNonNullElseGet(ApiRequestBuilder.this.bodyHandler, () -> ApiRequest.super.getBodyHandler());
            }
        };
    }

    public WrappedApi getWrappedApi() {
        return this.wrappedApi;
    }

    public Class<T> getResponseClass() {
        return this.responseClass;
    }
}

