/*
 * Decompiled with CFR 0.152.
 */
package com.telenordigital.nbiot;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.telenordigital.nbiot.Client;
import com.telenordigital.nbiot.ImmutableOutputDataMessage;
import com.telenordigital.nbiot.OutputDataMessageInternal;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.time.Instant;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OutputStream
implements WebSocket.Listener {
    private static final Logger logger = Logger.getLogger(OutputStream.class.getName());
    private Client.OutputHandler handler = null;
    private WebSocket webSocket = null;
    private String text = "";
    private ObjectMapper jacksonObjectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public OutputStream(URI uri, String token, Client.OutputHandler handler) {
        this.handler = handler;
        HttpClient client = HttpClient.newHttpClient();
        try {
            this.webSocket = client.newWebSocketBuilder().header("X-API-Token", token).buildAsync(uri, this).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.webSocket.sendClose(1000, "").join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence message, boolean last) {
        webSocket.request(1L);
        this.text = this.text + message.toString();
        if (last) {
            String fullText = this.text;
            this.text = "";
            try {
                OutputDataMessageInternal msgInternal = (OutputDataMessageInternal)this.jacksonObjectMapper.readValue(fullText, OutputDataMessageInternal.class);
                if (msgInternal.type().equals("data")) {
                    ImmutableOutputDataMessage msg = new ImmutableOutputDataMessage.Builder().device(msgInternal.device()).payload(msgInternal.payload()).received(Instant.ofEpochMilli(msgInternal.received())).build();
                    this.handler.onData(msg);
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error parsing message: {0}", e.toString());
                logger.log(Level.WARNING, "Message was: {0}", this.text);
            }
        }
        return null;
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        this.handler.onEnd();
        return null;
    }

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        logger.log(Level.WARNING, "{0}", error);
    }
}

