/*
 * Decompiled with CFR 0.152.
 */
package eu.securibox.cloudagents.api.documents;

import com.fasterxml.jackson.core.type.TypeReference;
import eu.securibox.cloudagents.api.documents.ApiClient;
import eu.securibox.cloudagents.api.documents.beans.Account;
import eu.securibox.cloudagents.api.documents.beans.AdditionalAuthData;
import eu.securibox.cloudagents.api.documents.beans.AdditionalAuthRequest;
import eu.securibox.cloudagents.api.documents.beans.Document;
import eu.securibox.cloudagents.api.documents.beans.Synchronization;
import eu.securibox.cloudagents.api.documents.beans.SynchronizationRequest;
import eu.securibox.cloudagents.core.Client;
import eu.securibox.cloudagents.core.Response;
import eu.securibox.cloudagents.core.Utils;
import eu.securibox.cloudagents.core.exceptions.ClientException;
import eu.securibox.cloudagents.core.exceptions.ResponseException;
import eu.securibox.cloudagents.core.http.UriParameters;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;

public class Accounts {
    private String path = "Accounts/";

    public Account createAccount(Account account, boolean synchronize) throws ClientException, ResponseException {
        Client c = ApiClient.getClient();
        CreateAccountRequest req = new CreateAccountRequest(account, synchronize);
        String payload = c.serialize(req);
        Response r = c.post(this.path, payload);
        return c.deserialize(r.getBody(), new TypeReference<Account>(){});
    }

    public List<Account> listAccounts() throws UnsupportedEncodingException, ClientException, ResponseException {
        return this.listAccounts(null, null, 0, 0);
    }

    public List<Account> listAccounts(String agentId, String customerUserId, int pageNumber, int pageSize) throws ClientException, ResponseException, UnsupportedEncodingException {
        Client c = ApiClient.getClient();
        UriParameters par = new UriParameters();
        par.put("agentId", agentId);
        par.put("customerUserId", customerUserId);
        par.put("skip", pageSize * pageNumber);
        par.put("take", pageNumber);
        Response r = c.get(this.path + "?" + par.getParameterString());
        return c.deserialize(r.getBody(), new TypeReference<List<Account>>(){});
    }

    public Account getAccount(String customerAccountId) throws ClientException, ResponseException {
        Client c = ApiClient.getClient();
        Response r = c.get(this.path + customerAccountId);
        return c.deserialize(r.getBody(), new TypeReference<Account>(){});
    }

    public Account updateAccount(Account account) throws ClientException, ResponseException {
        Client c = ApiClient.getClient();
        String payload = c.serialize(account);
        Response r = c.put(this.path + account.getCustomerAccountId(), payload);
        return c.deserialize(r.getBody(), new TypeReference<Account>(){});
    }

    public void deleteAccount(String customerAccountId) throws ClientException, ResponseException {
        Client c = ApiClient.getClient();
        c.delete(this.path + customerAccountId);
    }

    public List<Document> listDocumentsByAccount(String customerAccountId, boolean pendingOnly, boolean includeContent) throws ClientException, ResponseException, UnsupportedEncodingException {
        Client c = ApiClient.getClient();
        UriParameters par = new UriParameters();
        par.put("pendingOnly", pendingOnly);
        par.put("includeContent", includeContent);
        Response r = c.get(this.path + customerAccountId + "/documents?" + par.getParameterString());
        return c.deserialize(r.getBody(), new TypeReference<List<Document>>(){});
    }

    public List<Synchronization> listSynchronizationsByAccount(String customerAccountId, Date startDate, Date endDate) throws ClientException, ResponseException, UnsupportedEncodingException {
        Client c = ApiClient.getClient();
        UriParameters par = new UriParameters();
        par.put("startDate", startDate);
        par.put("endDate", endDate);
        Response r = c.get(this.path + customerAccountId + "/synchronizations?" + par.getParameterString());
        return c.deserialize(r.getBody(), new TypeReference<List<Synchronization>>(){});
    }

    public Synchronization getLastSynchronizationOfAccount(String customerAccountId) throws ClientException, ResponseException {
        Client c = ApiClient.getClient();
        Response r = c.get(this.path + customerAccountId + "/synchronizations/last");
        return c.deserialize(r.getBody(), new TypeReference<Synchronization>(){});
    }

    public Synchronization synchronizeAccount(String customerAccountId, boolean isForced) throws ClientException, ResponseException {
        Client c = ApiClient.getClient();
        SynchronizationRequest synchRequest = new SynchronizationRequest(customerAccountId, isForced);
        String payload = c.serialize(synchRequest);
        Response r = c.post(this.path + customerAccountId + "/synchronizations", payload);
        return c.deserialize(r.getBody(), new TypeReference<Synchronization>(){});
    }

    public boolean AddMultiFactorAuthenticationSecretCode(String customerAccountId, String secretCode) throws ClientException, ResponseException {
        if (Utils.nullOrEmpty(customerAccountId)) {
            throw new IllegalArgumentException("No customer account id provided.");
        }
        if (Utils.nullOrEmpty(secretCode)) {
            throw new IllegalArgumentException("No secret code provided.");
        }
        Client c = ApiClient.getClient();
        AdditionalAuthRequest request = new AdditionalAuthRequest(customerAccountId, secretCode);
        String payload = c.serialize(request);
        Response r = c.post(this.path + customerAccountId + "/mfa", payload);
        return r.getStatusCode() == 200;
    }

    public AdditionalAuthData GetMultifactorAuthenticationData(String customerAccountId) throws ClientException, ResponseException {
        if (Utils.nullOrEmpty(customerAccountId)) {
            throw new IllegalArgumentException("No customer account id provided.");
        }
        Client c = ApiClient.getClient();
        Response r = c.get(this.path + customerAccountId + "/mfa");
        return c.deserialize(r.getBody(), new TypeReference<AdditionalAuthData>(){});
    }

    private class CreateAccountRequest {
        private Account account;
        private boolean synchronize;

        CreateAccountRequest(Account account, boolean synchronize) {
            this.account = account;
            this.synchronize = synchronize;
        }
    }
}

