/*
 * Decompiled with CFR 0.152.
 */
package eu.securibox.cloudagents.api.documents;

import com.fasterxml.jackson.core.type.TypeReference;
import eu.securibox.cloudagents.api.documents.ApiClient;
import eu.securibox.cloudagents.api.documents.beans.Account;
import eu.securibox.cloudagents.api.documents.beans.Agent;
import eu.securibox.cloudagents.core.Client;
import eu.securibox.cloudagents.core.Response;
import eu.securibox.cloudagents.core.Utils;
import eu.securibox.cloudagents.core.exceptions.ClientException;
import eu.securibox.cloudagents.core.exceptions.ResponseException;
import eu.securibox.cloudagents.core.http.UriParameters;
import eu.securibox.cloudagents.core.types.CountryCode;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class Agents {
    private String path = "agents/";

    public List<Agent> listAgents() throws ClientException, ResponseException, UnsupportedEncodingException {
        return this.listAgents(null, false);
    }

    public List<Agent> listAgents(String culture) throws ClientException, ResponseException, UnsupportedEncodingException {
        return this.listAgents(culture, false);
    }

    public List<Agent> listAgents(String culture, boolean includeLogo) throws ClientException, ResponseException, UnsupportedEncodingException {
        Client c = ApiClient.getClient();
        String url = this.path;
        UriParameters parameters = new UriParameters();
        parameters.put("culture", culture);
        parameters.put("includeLogo", includeLogo);
        if (parameters.size() > 0) {
            url = url + "?" + parameters.getParameterString();
        }
        Response r = c.get(url);
        return c.deserialize(r.getBody(), new TypeReference<List<Agent>>(){});
    }

    public List<Agent> searchAgents(CountryCode countryCode, String culture, boolean includeLogo, String query) throws ClientException, ResponseException, UnsupportedEncodingException {
        Client c = ApiClient.getClient();
        String url = this.path + "search?";
        UriParameters par = new UriParameters();
        par.put("countryCode", countryCode);
        par.put("culture", culture);
        par.put("includeLogo", includeLogo);
        par.put("q", query);
        String url1 = url + par.getParameterString();
        Response r = c.get(url1);
        return c.deserialize(r.getBody(), new TypeReference<List<Agent>>(){});
    }

    public List<Account> listAccountsByAgent(String agentId, int skip, int take) throws ClientException, ResponseException, UnsupportedEncodingException {
        if (Utils.nullOrEmpty(agentId)) {
            throw new IllegalArgumentException("No agentId provided");
        }
        Client c = ApiClient.getClient();
        String url = this.path + agentId + "/accounts?";
        UriParameters par = new UriParameters();
        par.put("skip", skip);
        par.put("take", take);
        Response r = c.get(url + par.getParameterString());
        return c.deserialize(r.getBody(), new TypeReference<List<Account>>(){});
    }

    public Agent getAgentByIdentifier(String agentId) throws ClientException, ResponseException {
        if (Utils.nullOrEmpty(agentId)) {
            throw new IllegalArgumentException("No agentId provided");
        }
        Client c = ApiClient.getClient();
        String url = this.path + agentId;
        try {
            Response r = c.get(url);
            return c.deserialize(r.getBody(), new TypeReference<Agent>(){});
        }
        catch (ResponseException ex) {
            return null;
        }
    }
}

