/*
 * Decompiled with CFR 0.152.
 */
package eu.securibox.cloudagents.api.documents;

import eu.securibox.cloudagents.api.documents.Accounts;
import eu.securibox.cloudagents.api.documents.Agents;
import eu.securibox.cloudagents.api.documents.Categories;
import eu.securibox.cloudagents.api.documents.Documents;
import eu.securibox.cloudagents.api.documents.Synchronizations;
import eu.securibox.cloudagents.core.Client;
import eu.securibox.cloudagents.core.SecurityConfiguration;
import eu.securibox.cloudagents.core.Utils;
import eu.securibox.cloudagents.core.exceptions.SecurityConfigurationException;
import eu.securibox.cloudagents.core.http.HttpClient;

public class ApiClient {
    private static Client client;

    public static void ConfigureClient(String configFile) throws SecurityConfigurationException {
        client = HttpClient.FromConfigFile(configFile);
    }

    public static void ConfigureClient(SecurityConfiguration configuration) {
        client = new HttpClient(null, configuration);
    }

    public static void ConfigureClient(String baseUrl, SecurityConfiguration configuration) {
        if (Utils.nullOrEmpty(baseUrl)) {
            baseUrl = "https://sca-multitenant.securibox.eu/api/v1/";
        }
        client = new HttpClient(baseUrl, configuration);
    }

    static Client getClient() {
        if (client == null) {
            throw new NullPointerException("The client has not be configured yet. Call ConfigureClient before starting any API call");
        }
        return client;
    }

    public static Agents getAgentManager() {
        return new Agents();
    }

    public static Accounts getAccountManager() {
        return new Accounts();
    }

    public static Categories getCategoryManager() {
        return new Categories();
    }

    public static Documents getDocumentManager() {
        return new Documents();
    }

    public static Synchronizations getSynchronizationManager() {
        return new Synchronizations();
    }
}

