/*
 * Decompiled with CFR 0.152.
 */
package eu.securibox.cloudagents.api.documents;

import com.fasterxml.jackson.core.type.TypeReference;
import eu.securibox.cloudagents.api.documents.ApiClient;
import eu.securibox.cloudagents.api.documents.beans.Agent;
import eu.securibox.cloudagents.api.documents.beans.Category;
import eu.securibox.cloudagents.core.Client;
import eu.securibox.cloudagents.core.Response;
import eu.securibox.cloudagents.core.Utils;
import eu.securibox.cloudagents.core.exceptions.ClientException;
import eu.securibox.cloudagents.core.exceptions.ResponseException;
import eu.securibox.cloudagents.core.http.UriParameters;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class Categories {
    private static String path = "categories/";

    public List<Category> ListCategories(String culture) throws ClientException, ResponseException, UnsupportedEncodingException {
        Client c = ApiClient.getClient();
        UriParameters pars = new UriParameters();
        pars.put("culture", culture);
        Response r = c.get(path + "?" + pars.getParameterString());
        return c.deserialize(r.getBody(), new TypeReference<List<Category>>(){});
    }

    public List<Agent> ListAgentsByCategory(String categoryId) throws ClientException, ResponseException {
        if (Utils.nullOrEmpty(categoryId)) {
            throw new IllegalArgumentException("Null or empty categoryId was provided");
        }
        Client c = ApiClient.getClient();
        Response r = c.get(path + categoryId + "/agents");
        return c.deserialize(r.getBody(), new TypeReference<List<Agent>>(){});
    }
}

