/*
 * Decompiled with CFR 0.152.
 */
package eu.securibox.cloudagents.api.documents;

import com.fasterxml.jackson.core.type.TypeReference;
import eu.securibox.cloudagents.api.documents.ApiClient;
import eu.securibox.cloudagents.api.documents.beans.Document;
import eu.securibox.cloudagents.core.Client;
import eu.securibox.cloudagents.core.Response;
import eu.securibox.cloudagents.core.exceptions.ClientException;
import eu.securibox.cloudagents.core.exceptions.ResponseException;
import eu.securibox.cloudagents.core.http.UriParameters;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class Documents {
    private static String path = "documents/";

    public List<Document> searchDocuments(String customerAccountId, String customerUserId, boolean pendingOnly, boolean includeContent) throws ClientException, ResponseException, UnsupportedEncodingException {
        Client c = ApiClient.getClient();
        UriParameters pars = new UriParameters();
        pars.put("customerAccountId", customerAccountId);
        pars.put("customerUserId", customerUserId);
        pars.put("pendingOnly", pendingOnly);
        pars.put("includeContent", includeContent);
        Response r = c.get(path + "search?" + pars.getParameterString());
        return c.deserialize(r.getBody(), new TypeReference<List<Document>>(){});
    }

    public Document getDocument(long id, boolean includeContent) throws ClientException, ResponseException, UnsupportedEncodingException {
        Client c = ApiClient.getClient();
        UriParameters pars = new UriParameters();
        pars.put("includeContent", includeContent);
        Response r = c.get(path + Long.toString(id) + "?" + pars.getParameterString());
        return c.deserialize(r.getBody(), new TypeReference<Document>(){});
    }

    public void acknowledgeDocumentDelivery(long id) throws ClientException, ResponseException {
        Client c = ApiClient.getClient();
        String payload = c.serialize(id);
        c.put(path + Long.toString(id) + "/ack?", payload);
    }
}

