/*
 * Decompiled with CFR 0.152.
 */
package eu.securibox.cloudagents.api.documents;

import com.fasterxml.jackson.core.type.TypeReference;
import eu.securibox.cloudagents.api.documents.ApiClient;
import eu.securibox.cloudagents.api.documents.beans.Synchronization;
import eu.securibox.cloudagents.core.Client;
import eu.securibox.cloudagents.core.Response;
import eu.securibox.cloudagents.core.Utils;
import eu.securibox.cloudagents.core.exceptions.ClientException;
import eu.securibox.cloudagents.core.exceptions.ResponseException;
import eu.securibox.cloudagents.core.http.UriParameters;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;

public class Synchronizations {
    private static String path = "synchronizations/";

    public List<Synchronization> createSynchronizations(String customerAccountId, String customerUserId, boolean isForced) throws ClientException, ResponseException {
        Client c = ApiClient.getClient();
        SynchronizeRequest req = new SynchronizeRequest(customerAccountId, customerUserId, isForced);
        String payload = c.serialize(req);
        Response r = c.post(path, payload);
        return c.deserialize(r.getBody(), new TypeReference<List<Synchronization>>(){});
    }

    public List<Synchronization> searchSynchronizations(String customerAccountId, String customerUserId, Date startDate, Date endDate) throws ClientException, ResponseException, UnsupportedEncodingException {
        if (Utils.nullOrEmpty(customerUserId) && Utils.nullOrEmpty(customerAccountId)) {
            throw new IllegalArgumentException("Arguments customerAccountId and customerUserId can not be both null or empty");
        }
        Client c = ApiClient.getClient();
        UriParameters pars = new UriParameters();
        pars.put("customerAccountId", customerAccountId);
        pars.put("customerUserId", customerUserId);
        pars.put("startDate", startDate);
        pars.put("endDate", endDate);
        Response r = c.get(path + "search?" + pars.getParameterString());
        return c.deserialize(r.getBody(), new TypeReference<List<Synchronization>>(){});
    }

    public void acknowledgeSynchronizationDelivery(String customerAccountId, long[] documentIds, long[] missingDocumentIds) throws ClientException, ResponseException {
        Client c = ApiClient.getClient();
        SynchronizationAcknowledgement ackn = new SynchronizationAcknowledgement(customerAccountId, documentIds, missingDocumentIds);
        String payload = c.serialize(ackn);
        c.put(path + customerAccountId + "/ack", payload);
    }

    private class SynchronizeRequest {
        private String customerAccountId;
        private String customerUserId;
        private boolean isForced;

        SynchronizeRequest(String customerAccountId, String customerUserId, boolean isForced) {
            this.customerAccountId = customerAccountId;
            this.customerUserId = customerUserId;
            this.isForced = isForced;
        }
    }

    private class SynchronizationAcknowledgement {
        private String customerAccountId;
        private long[] documentIds;
        private long[] missingDocumentIds;

        SynchronizationAcknowledgement(String customerAccountId, long[] documentIds, long[] missingDocumentIds) {
            this.customerAccountId = customerAccountId;
            this.documentIds = documentIds;
            this.missingDocumentIds = missingDocumentIds;
        }
    }
}

