/*
 * Decompiled with CFR 0.152.
 */
package eu.securibox.cloudagents.core.auth.jwt;

import eu.securibox.cloudagents.core.auth.jwt.JWTParser;
import eu.securibox.cloudagents.core.auth.jwt.TokenUtils;
import eu.securibox.cloudagents.core.auth.jwt.exceptions.JWTDecodeException;
import eu.securibox.cloudagents.core.auth.jwt.parts.Claim;
import eu.securibox.cloudagents.core.auth.jwt.parts.Header;
import eu.securibox.cloudagents.core.auth.jwt.parts.Payload;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

public class DecodedJWT {
    private final String[] parts;
    private final Header header;
    private final Payload payload;

    DecodedJWT(String jwt) throws JWTDecodeException {
        String payloadJson;
        String headerJson;
        this.parts = TokenUtils.splitToken(jwt);
        JWTParser converter = new JWTParser();
        try {
            headerJson = StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)this.parts[0]));
            payloadJson = StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)this.parts[1]));
        }
        catch (NullPointerException e) {
            throw new JWTDecodeException("The UTF-8 Charset isn't initialized.", e);
        }
        this.header = converter.parseHeader(headerJson);
        this.payload = converter.parsePayload(payloadJson);
    }

    public String getAlgorithm() {
        return this.header.getAlgorithm();
    }

    public String getType() {
        return this.header.getType();
    }

    public String getContentType() {
        return this.header.getContentType();
    }

    public String getKeyId() {
        return this.header.getKeyId();
    }

    public Claim getHeaderClaim(String name) {
        return this.header.getHeaderClaim(name);
    }

    public String getIssuer() {
        return this.payload.getIssuer();
    }

    public String getSubject() {
        return this.payload.getSubject();
    }

    public List<String> getAudience() {
        return this.payload.getAudience();
    }

    public Date getExpiresAt() {
        return this.payload.getExpiresAt();
    }

    public Date getNotBefore() {
        return this.payload.getNotBefore();
    }

    public Date getIssuedAt() {
        return this.payload.getIssuedAt();
    }

    public String getId() {
        return this.payload.getId();
    }

    public Claim getClaim(String name) {
        return this.payload.getClaim(name);
    }

    public Map<String, Claim> getClaims() {
        return this.payload.getClaims();
    }

    public String getHeader() {
        return this.parts[0];
    }

    public String getPayload() {
        return this.parts[1];
    }

    public String getSignature() {
        return this.parts[2];
    }

    public String getToken() {
        return String.format("%s.%s.%s", this.parts[0], this.parts[1], this.parts[2]);
    }
}

