/*
 * Decompiled with CFR 0.152.
 */
package eu.securibox.cloudagents.core.auth.jwt;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import eu.securibox.cloudagents.core.auth.jwt.exceptions.JWTDecodeException;
import eu.securibox.cloudagents.core.auth.jwt.parts.Header;
import eu.securibox.cloudagents.core.auth.jwt.parts.HeaderDeserializer;
import eu.securibox.cloudagents.core.auth.jwt.parts.Payload;
import eu.securibox.cloudagents.core.auth.jwt.parts.PayloadDeserializer;
import java.io.IOException;

public class JWTParser {
    private ObjectMapper mapper;

    public JWTParser() {
        this(JWTParser.getDefaultObjectMapper());
    }

    JWTParser(ObjectMapper mapper) {
        this.addDeserializers(mapper);
        this.mapper = mapper;
    }

    public Payload parsePayload(String json) throws JWTDecodeException {
        return this.convertFromJSON(json, Payload.class);
    }

    public Header parseHeader(String json) throws JWTDecodeException {
        return this.convertFromJSON(json, Header.class);
    }

    private void addDeserializers(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Payload.class, (JsonDeserializer)new PayloadDeserializer());
        module.addDeserializer(Header.class, (JsonDeserializer)new HeaderDeserializer());
        mapper.registerModule((Module)module);
    }

    static ObjectMapper getDefaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return mapper;
    }

    <T> T convertFromJSON(String json, Class<T> tClazz) throws JWTDecodeException {
        if (json == null) {
            throw this.exceptionForInvalidJson(null);
        }
        try {
            return (T)this.mapper.readValue(json, tClazz);
        }
        catch (IOException e) {
            throw this.exceptionForInvalidJson(json);
        }
    }

    private JWTDecodeException exceptionForInvalidJson(String json) {
        return new JWTDecodeException(String.format("The string '%s' doesn't have a valid JSON format.", json));
    }
}

