/*
 * Decompiled with CFR 0.152.
 */
package eu.securibox.cloudagents.core.auth.jwt.algorithms;

import eu.securibox.cloudagents.core.auth.jwt.DecodedJWT;
import eu.securibox.cloudagents.core.auth.jwt.algorithms.AlgorithmRSA;
import eu.securibox.cloudagents.core.auth.jwt.algorithms.NoneAlgorithm;
import eu.securibox.cloudagents.core.auth.jwt.algorithms.RSAKeyProvider;
import eu.securibox.cloudagents.core.auth.jwt.exceptions.SignatureGenerationException;
import eu.securibox.cloudagents.core.auth.jwt.exceptions.SignatureVerificationException;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public abstract class Algorithm {
    private final String name;
    private final String description;

    public static Algorithm RSA256(RSAKeyProvider keyProvider) throws IllegalArgumentException {
        return new AlgorithmRSA("RS256", "SHA256withRSA", keyProvider);
    }

    public static Algorithm RSA256(RSAPublicKey publicKey, RSAPrivateKey privateKey) throws IllegalArgumentException {
        return Algorithm.RSA256(AlgorithmRSA.providerForKeys(publicKey, privateKey));
    }

    @Deprecated
    public static Algorithm RSA256(RSAKey key) throws IllegalArgumentException {
        RSAPublicKey publicKey = key instanceof RSAPublicKey ? (RSAPublicKey)key : null;
        RSAPrivateKey privateKey = key instanceof RSAPrivateKey ? (RSAPrivateKey)key : null;
        return Algorithm.RSA256(publicKey, privateKey);
    }

    public static Algorithm RSA384(RSAKeyProvider keyProvider) throws IllegalArgumentException {
        return new AlgorithmRSA("RS384", "SHA384withRSA", keyProvider);
    }

    public static Algorithm RSA384(RSAPublicKey publicKey, RSAPrivateKey privateKey) throws IllegalArgumentException {
        return Algorithm.RSA384(AlgorithmRSA.providerForKeys(publicKey, privateKey));
    }

    @Deprecated
    public static Algorithm RSA384(RSAKey key) throws IllegalArgumentException {
        RSAPublicKey publicKey = key instanceof RSAPublicKey ? (RSAPublicKey)key : null;
        RSAPrivateKey privateKey = key instanceof RSAPrivateKey ? (RSAPrivateKey)key : null;
        return Algorithm.RSA384(publicKey, privateKey);
    }

    public static Algorithm RSA512(RSAKeyProvider keyProvider) throws IllegalArgumentException {
        return new AlgorithmRSA("RS512", "SHA512withRSA", keyProvider);
    }

    public static Algorithm RSA512(RSAPublicKey publicKey, RSAPrivateKey privateKey) throws IllegalArgumentException {
        return Algorithm.RSA512(AlgorithmRSA.providerForKeys(publicKey, privateKey));
    }

    @Deprecated
    public static Algorithm RSA512(RSAKey key) throws IllegalArgumentException {
        RSAPublicKey publicKey = key instanceof RSAPublicKey ? (RSAPublicKey)key : null;
        RSAPrivateKey privateKey = key instanceof RSAPrivateKey ? (RSAPrivateKey)key : null;
        return Algorithm.RSA512(publicKey, privateKey);
    }

    public static Algorithm none() {
        return new NoneAlgorithm();
    }

    protected Algorithm(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getSigningKeyId() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    public abstract void verify(DecodedJWT var1) throws SignatureVerificationException;

    public abstract byte[] sign(byte[] var1) throws SignatureGenerationException;
}

