/*
 * Decompiled with CFR 0.152.
 */
package eu.securibox.cloudagents.core.auth.jwt.algorithms;

import eu.securibox.cloudagents.core.auth.jwt.DecodedJWT;
import eu.securibox.cloudagents.core.auth.jwt.algorithms.Algorithm;
import eu.securibox.cloudagents.core.auth.jwt.algorithms.CryptoHelper;
import eu.securibox.cloudagents.core.auth.jwt.algorithms.RSAKeyProvider;
import eu.securibox.cloudagents.core.auth.jwt.exceptions.SignatureGenerationException;
import eu.securibox.cloudagents.core.auth.jwt.exceptions.SignatureVerificationException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.apache.commons.codec.binary.Base64;

public class AlgorithmRSA
extends Algorithm {
    private final RSAKeyProvider keyProvider;
    private final CryptoHelper crypto;

    AlgorithmRSA(CryptoHelper crypto, String id, String algorithm, RSAKeyProvider keyProvider) throws IllegalArgumentException {
        super(id, algorithm);
        if (keyProvider == null) {
            throw new IllegalArgumentException("The Key Provider cannot be null.");
        }
        this.keyProvider = keyProvider;
        this.crypto = crypto;
    }

    AlgorithmRSA(String id, String algorithm, RSAKeyProvider keyProvider) throws IllegalArgumentException {
        this(new CryptoHelper(), id, algorithm, keyProvider);
    }

    @Override
    public void verify(DecodedJWT jwt) throws SignatureVerificationException {
        byte[] contentBytes = String.format("%s.%s", jwt.getHeader(), jwt.getPayload()).getBytes(StandardCharsets.UTF_8);
        byte[] signatureBytes = Base64.decodeBase64((String)jwt.getSignature());
        try {
            RSAPublicKey publicKey = (RSAPublicKey)this.keyProvider.getPublicKeyById(jwt.getKeyId());
            if (publicKey == null) {
                throw new IllegalStateException("The given Public Key is null.");
            }
            boolean valid = this.crypto.verifySignatureFor(this.getDescription(), publicKey, contentBytes, signatureBytes);
            if (!valid) {
                throw new SignatureVerificationException(this);
            }
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SignatureVerificationException(this, (Throwable)e);
        }
    }

    @Override
    public byte[] sign(byte[] contentBytes) throws SignatureGenerationException {
        try {
            RSAPrivateKey privateKey = (RSAPrivateKey)this.keyProvider.getPrivateKey();
            if (privateKey == null) {
                throw new IllegalStateException("The given Private Key is null.");
            }
            return this.crypto.createSignatureFor(this.getDescription(), privateKey, contentBytes);
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SignatureGenerationException(this, (Throwable)e);
        }
    }

    @Override
    public String getSigningKeyId() {
        return this.keyProvider.getPrivateKeyId();
    }

    static RSAKeyProvider providerForKeys(final RSAPublicKey publicKey, final RSAPrivateKey privateKey) {
        if (publicKey == null && privateKey == null) {
            throw new IllegalArgumentException("Both provided Keys cannot be null.");
        }
        return new RSAKeyProvider(){

            @Override
            public RSAPublicKey getPublicKeyById(String keyId) {
                return publicKey;
            }

            @Override
            public RSAPrivateKey getPrivateKey() {
                return privateKey;
            }

            @Override
            public String getPrivateKeyId() {
                return null;
            }
        };
    }
}

