/*
 * Decompiled with CFR 0.152.
 */
package eu.securibox.cloudagents.core.auth.jwt.parts;

import com.fasterxml.jackson.databind.JsonNode;
import eu.securibox.cloudagents.core.auth.jwt.parts.Claim;
import eu.securibox.cloudagents.core.auth.jwt.parts.JsonNodeClaim;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Header {
    private final String algorithm;
    private final String type;
    private final String contentType;
    private final String keyId;
    private final Map<String, JsonNode> tree;

    Header(String algorithm, String type, String contentType, String keyId, Map<String, JsonNode> tree) {
        this.algorithm = algorithm;
        this.type = type;
        this.contentType = contentType;
        this.keyId = keyId;
        this.tree = Collections.unmodifiableMap(tree == null ? new HashMap() : tree);
    }

    Map<String, JsonNode> getTree() {
        return this.tree;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getType() {
        return this.type;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public Claim getHeaderClaim(String name) {
        return JsonNodeClaim.extractClaim(name, this.tree);
    }
}

